/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaInvoice;
import telegram4j.tl.WebDocument;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaInvoice
implements MessageMediaInvoice {
    private final int identifier;
    private final int flags;
    private final boolean shippingAddressRequested;
    private final boolean test;
    private final String title;
    private final String description;
    @Nullable
    private final WebDocument photo;
    @Nullable
    private final Integer receiptMsgId;
    private final String currency;
    private final long totalAmount;
    private final String startParam;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageMediaInvoice(String title, String description, String currency, long totalAmount, String startParam) {
        this.title = Objects.requireNonNull(title, "title");
        this.description = Objects.requireNonNull(description, "description");
        this.currency = Objects.requireNonNull(currency, "currency");
        this.totalAmount = totalAmount;
        this.startParam = Objects.requireNonNull(startParam, "startParam");
        this.photo = null;
        this.receiptMsgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.shippingAddressRequested = this.initShim.shippingAddressRequested();
        this.test = this.initShim.test();
        this.initShim = null;
    }

    private ImmutableMessageMediaInvoice(Builder builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.photo = builder.photo;
        this.receiptMsgId = builder.receiptMsgId;
        this.currency = builder.currency;
        this.totalAmount = builder.totalAmount;
        this.startParam = builder.startParam;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.shippingAddressRequestedIsSet()) {
            this.initShim.shippingAddressRequested(builder.shippingAddressRequested);
        }
        if (builder.testIsSet()) {
            this.initShim.test(builder.test);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.shippingAddressRequested = this.initShim.shippingAddressRequested();
        this.test = this.initShim.test();
        this.initShim = null;
    }

    private ImmutableMessageMediaInvoice(int identifier, int flags, boolean shippingAddressRequested, boolean test, String title, String description, @Nullable WebDocument photo, @Nullable Integer receiptMsgId, String currency, long totalAmount, String startParam) {
        this.identifier = identifier;
        this.flags = flags;
        this.shippingAddressRequested = shippingAddressRequested;
        this.test = test;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.receiptMsgId = receiptMsgId;
        this.currency = currency;
        this.totalAmount = totalAmount;
        this.startParam = startParam;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageMediaInvoice.super.identifier();
    }

    private int flagsInitialize() {
        return MessageMediaInvoice.super.flags();
    }

    private boolean shippingAddressRequestedInitialize() {
        return MessageMediaInvoice.super.shippingAddressRequested();
    }

    private boolean testInitialize() {
        return MessageMediaInvoice.super.test();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean shippingAddressRequested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shippingAddressRequested() : this.shippingAddressRequested;
    }

    @Override
    public boolean test() {
        InitShim shim = this.initShim;
        return shim != null ? shim.test() : this.test;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public WebDocument photo() {
        return this.photo;
    }

    @Override
    @Nullable
    public Integer receiptMsgId() {
        return this.receiptMsgId;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long totalAmount() {
        return this.totalAmount;
    }

    @Override
    public String startParam() {
        return this.startParam;
    }

    public final ImmutableMessageMediaInvoice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(value, this.flags, this.shippingAddressRequested, this.test, this.title, this.description, this.photo, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, value, this.shippingAddressRequested, this.test, this.title, this.description, this.photo, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withShippingAddressRequested(boolean value) {
        if (this.shippingAddressRequested == value) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, value, this.test, this.title, this.description, this.photo, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withTest(boolean value) {
        if (this.test == value) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, value, this.title, this.description, this.photo, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, newValue, this.description, this.photo, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, this.title, newValue, this.photo, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withPhoto(@Nullable WebDocument value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, this.title, this.description, value, this.receiptMsgId, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withReceiptMsgId(@Nullable Integer value) {
        if (Objects.equals(this.receiptMsgId, value)) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, this.title, this.description, this.photo, value, this.currency, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, this.title, this.description, this.photo, this.receiptMsgId, newValue, this.totalAmount, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withTotalAmount(long value) {
        if (this.totalAmount == value) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, this.title, this.description, this.photo, this.receiptMsgId, this.currency, value, this.startParam);
    }

    public final ImmutableMessageMediaInvoice withStartParam(String value) {
        String newValue = Objects.requireNonNull(value, "startParam");
        if (this.startParam.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaInvoice(this.identifier, this.flags, this.shippingAddressRequested, this.test, this.title, this.description, this.photo, this.receiptMsgId, this.currency, this.totalAmount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaInvoice && this.equalTo(0, (ImmutableMessageMediaInvoice)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaInvoice another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.shippingAddressRequested == another.shippingAddressRequested && this.test == another.test && this.title.equals(another.title) && this.description.equals(another.description) && Objects.equals(this.photo, another.photo) && Objects.equals(this.receiptMsgId, another.receiptMsgId) && this.currency.equals(another.currency) && this.totalAmount == another.totalAmount && this.startParam.equals(another.startParam);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.shippingAddressRequested);
        h += (h << 5) + Boolean.hashCode(this.test);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + Objects.hashCode(this.receiptMsgId);
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.totalAmount);
        h += (h << 5) + this.startParam.hashCode();
        return h;
    }

    public String toString() {
        return "MessageMediaInvoice{identifier=" + this.identifier + ", flags=" + this.flags + ", shippingAddressRequested=" + this.shippingAddressRequested + ", test=" + this.test + ", title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", receiptMsgId=" + this.receiptMsgId + ", currency=" + this.currency + ", totalAmount=" + this.totalAmount + ", startParam=" + this.startParam + "}";
    }

    public static ImmutableMessageMediaInvoice of(String title, String description, String currency, long totalAmount, String startParam) {
        return new ImmutableMessageMediaInvoice(title, description, currency, totalAmount, startParam);
    }

    public static ImmutableMessageMediaInvoice copyOf(MessageMediaInvoice instance) {
        if (instance instanceof ImmutableMessageMediaInvoice) {
            return (ImmutableMessageMediaInvoice)instance;
        }
        return ImmutableMessageMediaInvoice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long INIT_BIT_CURRENCY = 4L;
        private static final long INIT_BIT_TOTAL_AMOUNT = 8L;
        private static final long INIT_BIT_START_PARAM = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SHIPPING_ADDRESS_REQUESTED = 4L;
        private static final long OPT_BIT_TEST = 8L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean shippingAddressRequested;
        private boolean test;
        private String title;
        private String description;
        private WebDocument photo;
        private Integer receiptMsgId;
        private String currency;
        private long totalAmount;
        private String startParam;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaInvoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaInvoice) {
                instance = (MessageMediaInvoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.totalAmount(instance.totalAmount());
                Integer receiptMsgIdValue = instance.receiptMsgId();
                if (receiptMsgIdValue != null) {
                    this.receiptMsgId(receiptMsgIdValue);
                }
                this.test(instance.test());
                this.startParam(instance.startParam());
                this.shippingAddressRequested(instance.shippingAddressRequested());
                this.flags(instance.flags());
                this.description(instance.description());
                WebDocument photoValue = instance.photo();
                if (photoValue != null) {
                    this.photo(photoValue);
                }
                this.currency(instance.currency());
                this.title(instance.title());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder shippingAddressRequested(boolean shippingAddressRequested) {
            this.shippingAddressRequested = shippingAddressRequested;
            this.optBits |= 4L;
            return this;
        }

        public final Builder test(boolean test) {
            this.test = test;
            this.optBits |= 8L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(@Nullable WebDocument photo) {
            this.photo = photo;
            return this;
        }

        public final Builder receiptMsgId(@Nullable Integer receiptMsgId) {
            this.receiptMsgId = receiptMsgId;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder totalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder startParam(String startParam) {
            this.startParam = Objects.requireNonNull(startParam, "startParam");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableMessageMediaInvoice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaInvoice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean shippingAddressRequestedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean testIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("totalAmount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("startParam");
            }
            return "Cannot build MessageMediaInvoice, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte shippingAddressRequestedBuildStage = 0;
        private boolean shippingAddressRequested;
        private byte testBuildStage = 0;
        private boolean test;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageMediaInvoice.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageMediaInvoice.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean shippingAddressRequested() {
            if (this.shippingAddressRequestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shippingAddressRequestedBuildStage == 0) {
                this.shippingAddressRequestedBuildStage = (byte)-1;
                this.shippingAddressRequested = ImmutableMessageMediaInvoice.this.shippingAddressRequestedInitialize();
                this.shippingAddressRequestedBuildStage = 1;
            }
            return this.shippingAddressRequested;
        }

        void shippingAddressRequested(boolean shippingAddressRequested) {
            this.shippingAddressRequested = shippingAddressRequested;
            this.shippingAddressRequestedBuildStage = 1;
        }

        boolean test() {
            if (this.testBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.testBuildStage == 0) {
                this.testBuildStage = (byte)-1;
                this.test = ImmutableMessageMediaInvoice.this.testInitialize();
                this.testBuildStage = 1;
            }
            return this.test;
        }

        void test(boolean test) {
            this.test = test;
            this.testBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.shippingAddressRequestedBuildStage == -1) {
                attributes.add("shippingAddressRequested");
            }
            if (this.testBuildStage == -1) {
                attributes.add("test");
            }
            return "Cannot build MessageMediaInvoice, attribute initializers form cycle " + attributes;
        }
    }
}

