/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaPhoto;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaPhoto
implements MessageMediaPhoto {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Photo photo;
    @Nullable
    private final Integer ttlSeconds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableMessageMediaPhoto INSTANCE = ImmutableMessageMediaPhoto.validate(new ImmutableMessageMediaPhoto());

    private ImmutableMessageMediaPhoto() {
        this.photo = null;
        this.ttlSeconds = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageMediaPhoto(Builder builder) {
        this.photo = builder.photo;
        this.ttlSeconds = builder.ttlSeconds;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageMediaPhoto(int identifier, int flags, @Nullable Photo photo, @Nullable Integer ttlSeconds) {
        this.identifier = identifier;
        this.flags = flags;
        this.photo = photo;
        this.ttlSeconds = ttlSeconds;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageMediaPhoto.super.identifier();
    }

    private int flagsInitialize() {
        return MessageMediaPhoto.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Photo photo() {
        return this.photo;
    }

    @Override
    @Nullable
    public Integer ttlSeconds() {
        return this.ttlSeconds;
    }

    public final ImmutableMessageMediaPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageMediaPhoto.validate(new ImmutableMessageMediaPhoto(value, this.flags, this.photo, this.ttlSeconds));
    }

    public final ImmutableMessageMediaPhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableMessageMediaPhoto.validate(new ImmutableMessageMediaPhoto(this.identifier, value, this.photo, this.ttlSeconds));
    }

    public final ImmutableMessageMediaPhoto withPhoto(@Nullable Photo value) {
        if (this.photo == value) {
            return this;
        }
        return ImmutableMessageMediaPhoto.validate(new ImmutableMessageMediaPhoto(this.identifier, this.flags, value, this.ttlSeconds));
    }

    public final ImmutableMessageMediaPhoto withTtlSeconds(@Nullable Integer value) {
        if (Objects.equals(this.ttlSeconds, value)) {
            return this;
        }
        return ImmutableMessageMediaPhoto.validate(new ImmutableMessageMediaPhoto(this.identifier, this.flags, this.photo, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaPhoto && this.equalTo(0, (ImmutableMessageMediaPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaPhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.photo, another.photo) && Objects.equals(this.ttlSeconds, another.ttlSeconds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + Objects.hashCode(this.ttlSeconds);
        return h;
    }

    public String toString() {
        return "MessageMediaPhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", photo=" + this.photo + ", ttlSeconds=" + this.ttlSeconds + "}";
    }

    public static ImmutableMessageMediaPhoto of() {
        return INSTANCE;
    }

    private static ImmutableMessageMediaPhoto validate(ImmutableMessageMediaPhoto instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageMediaPhoto copyOf(MessageMediaPhoto instance) {
        if (instance instanceof ImmutableMessageMediaPhoto) {
            return (ImmutableMessageMediaPhoto)instance;
        }
        return ImmutableMessageMediaPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Photo photo;
        private Integer ttlSeconds;

        private Builder() {
        }

        public final Builder from(MessageMediaPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMediaPhoto) {
                Integer ttlSecondsValue;
                Photo photoValue;
                instance = (MessageMediaPhoto)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((photoValue = instance.photo()) != null) {
                    this.photo(photoValue);
                }
                if ((ttlSecondsValue = instance.ttlSeconds()) != null) {
                    this.ttlSeconds(ttlSecondsValue);
                }
            }
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder photo(@Nullable Photo photo) {
            this.photo = photo;
            return this;
        }

        public final Builder ttlSeconds(@Nullable Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public ImmutableMessageMediaPhoto build() {
            return ImmutableMessageMediaPhoto.validate(new ImmutableMessageMediaPhoto(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageMediaPhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageMediaPhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build MessageMediaPhoto, attribute initializers form cycle " + attributes;
        }
    }
}

