/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaPoll;
import telegram4j.tl.Poll;
import telegram4j.tl.PollResults;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaPoll
implements MessageMediaPoll {
    private final int identifier;
    private final Poll poll;
    private final PollResults results;

    private ImmutableMessageMediaPoll(Poll poll, PollResults results) {
        this.poll = Objects.requireNonNull(poll, "poll");
        this.results = Objects.requireNonNull(results, "results");
        this.identifier = MessageMediaPoll.super.identifier();
    }

    private ImmutableMessageMediaPoll(Builder builder) {
        this.poll = builder.poll;
        this.results = builder.results;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaPoll.super.identifier();
    }

    private ImmutableMessageMediaPoll(int identifier, Poll poll, PollResults results) {
        this.identifier = identifier;
        this.poll = poll;
        this.results = results;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Poll poll() {
        return this.poll;
    }

    @Override
    public PollResults results() {
        return this.results;
    }

    public final ImmutableMessageMediaPoll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaPoll(value, this.poll, this.results);
    }

    public final ImmutableMessageMediaPoll withPoll(Poll value) {
        if (this.poll == value) {
            return this;
        }
        Poll newValue = Objects.requireNonNull(value, "poll");
        return new ImmutableMessageMediaPoll(this.identifier, newValue, this.results);
    }

    public final ImmutableMessageMediaPoll withResults(PollResults value) {
        if (this.results == value) {
            return this;
        }
        PollResults newValue = Objects.requireNonNull(value, "results");
        return new ImmutableMessageMediaPoll(this.identifier, this.poll, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaPoll && this.equalTo(0, (ImmutableMessageMediaPoll)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaPoll another) {
        return this.identifier == another.identifier && this.poll.equals(another.poll) && this.results.equals(another.results);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.poll.hashCode();
        h += (h << 5) + this.results.hashCode();
        return h;
    }

    public String toString() {
        return "MessageMediaPoll{identifier=" + this.identifier + ", poll=" + this.poll + ", results=" + this.results + "}";
    }

    public static ImmutableMessageMediaPoll of(Poll poll, PollResults results) {
        return new ImmutableMessageMediaPoll(poll, results);
    }

    public static ImmutableMessageMediaPoll copyOf(MessageMediaPoll instance) {
        if (instance instanceof ImmutableMessageMediaPoll) {
            return (ImmutableMessageMediaPoll)instance;
        }
        return ImmutableMessageMediaPoll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_POLL = 1L;
        private static final long INIT_BIT_RESULTS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Poll poll;
        private PollResults results;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaPoll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaPoll) {
                instance = (MessageMediaPoll)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.results(instance.results());
                this.poll(instance.poll());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder poll(Poll poll) {
            this.poll = Objects.requireNonNull(poll, "poll");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder results(PollResults results) {
            this.results = Objects.requireNonNull(results, "results");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageMediaPoll build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaPoll(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("poll");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("results");
            }
            return "Cannot build MessageMediaPoll, some of required attributes are not set " + attributes;
        }
    }
}

