/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaUnsupported;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaUnsupported
implements MessageMediaUnsupported {
    private final int identifier;
    private static final ImmutableMessageMediaUnsupported INSTANCE = ImmutableMessageMediaUnsupported.validate(new ImmutableMessageMediaUnsupported());

    private ImmutableMessageMediaUnsupported() {
        this.identifier = MessageMediaUnsupported.super.identifier();
    }

    private ImmutableMessageMediaUnsupported(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaUnsupported.super.identifier();
    }

    private ImmutableMessageMediaUnsupported(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableMessageMediaUnsupported withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageMediaUnsupported.validate(new ImmutableMessageMediaUnsupported(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaUnsupported && this.equalTo(0, (ImmutableMessageMediaUnsupported)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaUnsupported another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "MessageMediaUnsupported{identifier=" + this.identifier + "}";
    }

    public static ImmutableMessageMediaUnsupported of() {
        return INSTANCE;
    }

    private static ImmutableMessageMediaUnsupported validate(ImmutableMessageMediaUnsupported instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageMediaUnsupported copyOf(MessageMediaUnsupported instance) {
        if (instance instanceof ImmutableMessageMediaUnsupported) {
            return (ImmutableMessageMediaUnsupported)instance;
        }
        return ImmutableMessageMediaUnsupported.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaUnsupported instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaUnsupported) {
                instance = (MessageMediaUnsupported)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMessageMediaUnsupported build() {
            return ImmutableMessageMediaUnsupported.validate(new ImmutableMessageMediaUnsupported(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

