/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaVenue;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaVenue
implements MessageMediaVenue {
    private final int identifier;
    private final GeoPoint geo;
    private final String title;
    private final String address;
    private final String provider;
    private final String venueId;
    private final String venueType;

    private ImmutableMessageMediaVenue(GeoPoint geo, String title, String address, String provider, String venueId, String venueType) {
        this.geo = Objects.requireNonNull(geo, "geo");
        this.title = Objects.requireNonNull(title, "title");
        this.address = Objects.requireNonNull(address, "address");
        this.provider = Objects.requireNonNull(provider, "provider");
        this.venueId = Objects.requireNonNull(venueId, "venueId");
        this.venueType = Objects.requireNonNull(venueType, "venueType");
        this.identifier = MessageMediaVenue.super.identifier();
    }

    private ImmutableMessageMediaVenue(Builder builder) {
        this.geo = builder.geo;
        this.title = builder.title;
        this.address = builder.address;
        this.provider = builder.provider;
        this.venueId = builder.venueId;
        this.venueType = builder.venueType;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaVenue.super.identifier();
    }

    private ImmutableMessageMediaVenue(int identifier, GeoPoint geo, String title, String address, String provider, String venueId, String venueType) {
        this.identifier = identifier;
        this.geo = geo;
        this.title = title;
        this.address = address;
        this.provider = provider;
        this.venueId = venueId;
        this.venueType = venueType;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public GeoPoint geo() {
        return this.geo;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String venueId() {
        return this.venueId;
    }

    @Override
    public String venueType() {
        return this.venueType;
    }

    public final ImmutableMessageMediaVenue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaVenue(value, this.geo, this.title, this.address, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableMessageMediaVenue withGeo(GeoPoint value) {
        if (this.geo == value) {
            return this;
        }
        GeoPoint newValue = Objects.requireNonNull(value, "geo");
        return new ImmutableMessageMediaVenue(this.identifier, newValue, this.title, this.address, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableMessageMediaVenue withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaVenue(this.identifier, this.geo, newValue, this.address, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableMessageMediaVenue withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaVenue(this.identifier, this.geo, this.title, newValue, this.provider, this.venueId, this.venueType);
    }

    public final ImmutableMessageMediaVenue withProvider(String value) {
        String newValue = Objects.requireNonNull(value, "provider");
        if (this.provider.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaVenue(this.identifier, this.geo, this.title, this.address, newValue, this.venueId, this.venueType);
    }

    public final ImmutableMessageMediaVenue withVenueId(String value) {
        String newValue = Objects.requireNonNull(value, "venueId");
        if (this.venueId.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaVenue(this.identifier, this.geo, this.title, this.address, this.provider, newValue, this.venueType);
    }

    public final ImmutableMessageMediaVenue withVenueType(String value) {
        String newValue = Objects.requireNonNull(value, "venueType");
        if (this.venueType.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageMediaVenue(this.identifier, this.geo, this.title, this.address, this.provider, this.venueId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaVenue && this.equalTo(0, (ImmutableMessageMediaVenue)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaVenue another) {
        return this.identifier == another.identifier && this.geo.equals(another.geo) && this.title.equals(another.title) && this.address.equals(another.address) && this.provider.equals(another.provider) && this.venueId.equals(another.venueId) && this.venueType.equals(another.venueType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.geo.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.venueId.hashCode();
        h += (h << 5) + this.venueType.hashCode();
        return h;
    }

    public String toString() {
        return "MessageMediaVenue{identifier=" + this.identifier + ", geo=" + this.geo + ", title=" + this.title + ", address=" + this.address + ", provider=" + this.provider + ", venueId=" + this.venueId + ", venueType=" + this.venueType + "}";
    }

    public static ImmutableMessageMediaVenue of(GeoPoint geo, String title, String address, String provider, String venueId, String venueType) {
        return new ImmutableMessageMediaVenue(geo, title, address, provider, venueId, venueType);
    }

    public static ImmutableMessageMediaVenue copyOf(MessageMediaVenue instance) {
        if (instance instanceof ImmutableMessageMediaVenue) {
            return (ImmutableMessageMediaVenue)instance;
        }
        return ImmutableMessageMediaVenue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_PROVIDER = 8L;
        private static final long INIT_BIT_VENUE_ID = 16L;
        private static final long INIT_BIT_VENUE_TYPE = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private GeoPoint geo;
        private String title;
        private String address;
        private String provider;
        private String venueId;
        private String venueType;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaVenue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaVenue) {
                instance = (MessageMediaVenue)object;
                this.geo(instance.geo());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.address(instance.address());
                this.venueType(instance.venueType());
                this.provider(instance.provider());
                this.venueId(instance.venueId());
                this.title(instance.title());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder geo(GeoPoint geo) {
            this.geo = Objects.requireNonNull(geo, "geo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder venueId(String venueId) {
            this.venueId = Objects.requireNonNull(venueId, "venueId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder venueType(String venueType) {
            this.venueType = Objects.requireNonNull(venueType, "venueType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableMessageMediaVenue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaVenue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("provider");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("venueId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("venueType");
            }
            return "Cannot build MessageMediaVenue, some of required attributes are not set " + attributes;
        }
    }
}

