/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageMediaWebPage;
import telegram4j.tl.WebPage;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageMediaWebPage
implements MessageMediaWebPage {
    private final int identifier;
    private final WebPage webpage;

    private ImmutableMessageMediaWebPage(WebPage webpage) {
        this.webpage = Objects.requireNonNull(webpage, "webpage");
        this.identifier = MessageMediaWebPage.super.identifier();
    }

    private ImmutableMessageMediaWebPage(Builder builder) {
        this.webpage = builder.webpage;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageMediaWebPage.super.identifier();
    }

    private ImmutableMessageMediaWebPage(int identifier, WebPage webpage) {
        this.identifier = identifier;
        this.webpage = webpage;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public WebPage webpage() {
        return this.webpage;
    }

    public final ImmutableMessageMediaWebPage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageMediaWebPage(value, this.webpage);
    }

    public final ImmutableMessageMediaWebPage withWebpage(WebPage value) {
        if (this.webpage == value) {
            return this;
        }
        WebPage newValue = Objects.requireNonNull(value, "webpage");
        return new ImmutableMessageMediaWebPage(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageMediaWebPage && this.equalTo(0, (ImmutableMessageMediaWebPage)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageMediaWebPage another) {
        return this.identifier == another.identifier && this.webpage.equals(another.webpage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.webpage.hashCode();
        return h;
    }

    public String toString() {
        return "MessageMediaWebPage{identifier=" + this.identifier + ", webpage=" + this.webpage + "}";
    }

    public static ImmutableMessageMediaWebPage of(WebPage webpage) {
        return new ImmutableMessageMediaWebPage(webpage);
    }

    public static ImmutableMessageMediaWebPage copyOf(MessageMediaWebPage instance) {
        if (instance instanceof ImmutableMessageMediaWebPage) {
            return (ImmutableMessageMediaWebPage)instance;
        }
        return ImmutableMessageMediaWebPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_WEBPAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private WebPage webpage;

        private Builder() {
        }

        public final Builder from(MessageMedia instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageMediaWebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageMedia instance;
            long bits = 0L;
            if (object instanceof MessageMedia) {
                instance = (MessageMedia)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageMediaWebPage) {
                instance = (MessageMediaWebPage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.webpage(instance.webpage());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder webpage(WebPage webpage) {
            this.webpage = Objects.requireNonNull(webpage, "webpage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageMediaWebPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageMediaWebPage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("webpage");
            }
            return "Cannot build MessageMediaWebPage, some of required attributes are not set " + attributes;
        }
    }
}

