/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessagePeerReaction;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessagePeerReaction
implements MessagePeerReaction {
    private final int identifier;
    private final int flags;
    private final boolean big;
    private final boolean unread;
    private final Peer peerId;
    private final String reaction;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessagePeerReaction(Peer peerId, String reaction) {
        this.peerId = Objects.requireNonNull(peerId, "peerId");
        this.reaction = Objects.requireNonNull(reaction, "reaction");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.unread = this.initShim.unread();
        this.initShim = null;
    }

    private ImmutableMessagePeerReaction(Builder builder) {
        this.peerId = builder.peerId;
        this.reaction = builder.reaction;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.bigIsSet()) {
            this.initShim.big(builder.big);
        }
        if (builder.unreadIsSet()) {
            this.initShim.unread(builder.unread);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.big = this.initShim.big();
        this.unread = this.initShim.unread();
        this.initShim = null;
    }

    private ImmutableMessagePeerReaction(int identifier, int flags, boolean big, boolean unread, Peer peerId, String reaction) {
        this.identifier = identifier;
        this.flags = flags;
        this.big = big;
        this.unread = unread;
        this.peerId = peerId;
        this.reaction = reaction;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessagePeerReaction.super.identifier();
    }

    private int flagsInitialize() {
        return MessagePeerReaction.super.flags();
    }

    private boolean bigInitialize() {
        return MessagePeerReaction.super.big();
    }

    private boolean unreadInitialize() {
        return MessagePeerReaction.super.unread();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean big() {
        InitShim shim = this.initShim;
        return shim != null ? shim.big() : this.big;
    }

    @Override
    public boolean unread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unread() : this.unread;
    }

    @Override
    public Peer peerId() {
        return this.peerId;
    }

    @Override
    public String reaction() {
        return this.reaction;
    }

    public final ImmutableMessagePeerReaction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessagePeerReaction(value, this.flags, this.big, this.unread, this.peerId, this.reaction);
    }

    public final ImmutableMessagePeerReaction withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessagePeerReaction(this.identifier, value, this.big, this.unread, this.peerId, this.reaction);
    }

    public final ImmutableMessagePeerReaction withBig(boolean value) {
        if (this.big == value) {
            return this;
        }
        return new ImmutableMessagePeerReaction(this.identifier, this.flags, value, this.unread, this.peerId, this.reaction);
    }

    public final ImmutableMessagePeerReaction withUnread(boolean value) {
        if (this.unread == value) {
            return this;
        }
        return new ImmutableMessagePeerReaction(this.identifier, this.flags, this.big, value, this.peerId, this.reaction);
    }

    public final ImmutableMessagePeerReaction withPeerId(Peer value) {
        if (this.peerId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peerId");
        return new ImmutableMessagePeerReaction(this.identifier, this.flags, this.big, this.unread, newValue, this.reaction);
    }

    public final ImmutableMessagePeerReaction withReaction(String value) {
        String newValue = Objects.requireNonNull(value, "reaction");
        if (this.reaction.equals(newValue)) {
            return this;
        }
        return new ImmutableMessagePeerReaction(this.identifier, this.flags, this.big, this.unread, this.peerId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessagePeerReaction && this.equalTo(0, (ImmutableMessagePeerReaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessagePeerReaction another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.big == another.big && this.unread == another.unread && this.peerId.equals(another.peerId) && this.reaction.equals(another.reaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.big);
        h += (h << 5) + Boolean.hashCode(this.unread);
        h += (h << 5) + this.peerId.hashCode();
        h += (h << 5) + this.reaction.hashCode();
        return h;
    }

    public String toString() {
        return "MessagePeerReaction{identifier=" + this.identifier + ", flags=" + this.flags + ", big=" + this.big + ", unread=" + this.unread + ", peerId=" + this.peerId + ", reaction=" + this.reaction + "}";
    }

    public static ImmutableMessagePeerReaction of(Peer peerId, String reaction) {
        return new ImmutableMessagePeerReaction(peerId, reaction);
    }

    public static ImmutableMessagePeerReaction copyOf(MessagePeerReaction instance) {
        if (instance instanceof ImmutableMessagePeerReaction) {
            return (ImmutableMessagePeerReaction)instance;
        }
        return ImmutableMessagePeerReaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER_ID = 1L;
        private static final long INIT_BIT_REACTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BIG = 4L;
        private static final long OPT_BIT_UNREAD = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean big;
        private boolean unread;
        private Peer peerId;
        private String reaction;

        private Builder() {
        }

        public final Builder from(MessagePeerReaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessagePeerReaction instance;
            long bits = 0L;
            if (object instanceof MessagePeerReaction) {
                instance = (MessagePeerReaction)object;
                this.peerId(instance.peerId());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.big(instance.big());
                this.reaction(instance.reaction());
                this.unread(instance.unread());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder big(boolean big) {
            this.big = big;
            this.optBits |= 4L;
            return this;
        }

        public final Builder unread(boolean unread) {
            this.unread = unread;
            this.optBits |= 8L;
            return this;
        }

        public final Builder peerId(Peer peerId) {
            this.peerId = Objects.requireNonNull(peerId, "peerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reaction(String reaction) {
            this.reaction = Objects.requireNonNull(reaction, "reaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessagePeerReaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessagePeerReaction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean bigIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean unreadIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peerId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reaction");
            }
            return "Cannot build MessagePeerReaction, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte bigBuildStage = 0;
        private boolean big;
        private byte unreadBuildStage = 0;
        private boolean unread;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessagePeerReaction.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessagePeerReaction.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean big() {
            if (this.bigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bigBuildStage == 0) {
                this.bigBuildStage = (byte)-1;
                this.big = ImmutableMessagePeerReaction.this.bigInitialize();
                this.bigBuildStage = 1;
            }
            return this.big;
        }

        void big(boolean big) {
            this.big = big;
            this.bigBuildStage = 1;
        }

        boolean unread() {
            if (this.unreadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unreadBuildStage == 0) {
                this.unreadBuildStage = (byte)-1;
                this.unread = ImmutableMessagePeerReaction.this.unreadInitialize();
                this.unreadBuildStage = 1;
            }
            return this.unread;
        }

        void unread(boolean unread) {
            this.unread = unread;
            this.unreadBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.bigBuildStage == -1) {
                attributes.add("big");
            }
            if (this.unreadBuildStage == -1) {
                attributes.add("unread");
            }
            return "Cannot build MessagePeerReaction, attribute initializers form cycle " + attributes;
        }
    }
}

