/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageRange;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageRange
implements MessageRange {
    private final int identifier;
    private final int minId;
    private final int maxId;

    private ImmutableMessageRange(int minId, int maxId) {
        this.minId = minId;
        this.maxId = maxId;
        this.identifier = MessageRange.super.identifier();
    }

    private ImmutableMessageRange(Builder builder) {
        this.minId = builder.minId;
        this.maxId = builder.maxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageRange.super.identifier();
    }

    private ImmutableMessageRange(int identifier, int minId, int maxId) {
        this.identifier = identifier;
        this.minId = minId;
        this.maxId = maxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int minId() {
        return this.minId;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    public final ImmutableMessageRange withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageRange(value, this.minId, this.maxId);
    }

    public final ImmutableMessageRange withMinId(int value) {
        if (this.minId == value) {
            return this;
        }
        return new ImmutableMessageRange(this.identifier, value, this.maxId);
    }

    public final ImmutableMessageRange withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableMessageRange(this.identifier, this.minId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageRange && this.equalTo(0, (ImmutableMessageRange)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageRange another) {
        return this.identifier == another.identifier && this.minId == another.minId && this.maxId == another.maxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.minId;
        h += (h << 5) + this.maxId;
        return h;
    }

    public String toString() {
        return "MessageRange{identifier=" + this.identifier + ", minId=" + this.minId + ", maxId=" + this.maxId + "}";
    }

    public static ImmutableMessageRange of(int minId, int maxId) {
        return new ImmutableMessageRange(minId, maxId);
    }

    public static ImmutableMessageRange copyOf(MessageRange instance) {
        if (instance instanceof ImmutableMessageRange) {
            return (ImmutableMessageRange)instance;
        }
        return ImmutableMessageRange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MIN_ID = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int minId;
        private int maxId;

        private Builder() {
        }

        public final Builder from(MessageRange instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageRange instance;
            long bits = 0L;
            if (object instanceof MessageRange) {
                instance = (MessageRange)object;
                this.minId(instance.minId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder minId(int minId) {
            this.minId = minId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageRange build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageRange(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("minId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build MessageRange, some of required attributes are not set " + attributes;
        }
    }
}

