/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessagePeerReaction;
import telegram4j.tl.MessageReactions;
import telegram4j.tl.ReactionCount;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageReactions
implements MessageReactions {
    private final int identifier;
    private final int flags;
    private final boolean min;
    private final boolean canSeeList;
    private final List<ReactionCount> results;
    @Nullable
    private final List<MessagePeerReaction> recentReactions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReactions(Builder builder) {
        this.results = ImmutableMessageReactions.createUnmodifiableList(true, builder.results);
        List<MessagePeerReaction> list = this.recentReactions = builder.recentReactions == null ? null : ImmutableMessageReactions.createUnmodifiableList(true, builder.recentReactions);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.minIsSet()) {
            this.initShim.min(builder.min);
        }
        if (builder.canSeeListIsSet()) {
            this.initShim.canSeeList(builder.canSeeList);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.min = this.initShim.min();
        this.canSeeList = this.initShim.canSeeList();
        this.initShim = null;
    }

    private ImmutableMessageReactions(int identifier, int flags, boolean min, boolean canSeeList, List<ReactionCount> results, @Nullable List<MessagePeerReaction> recentReactions) {
        this.identifier = identifier;
        this.flags = flags;
        this.min = min;
        this.canSeeList = canSeeList;
        this.results = results;
        this.recentReactions = recentReactions;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageReactions.super.identifier();
    }

    private int flagsInitialize() {
        return MessageReactions.super.flags();
    }

    private boolean minInitialize() {
        return MessageReactions.super.min();
    }

    private boolean canSeeListInitialize() {
        return MessageReactions.super.canSeeList();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean min() {
        InitShim shim = this.initShim;
        return shim != null ? shim.min() : this.min;
    }

    @Override
    public boolean canSeeList() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSeeList() : this.canSeeList;
    }

    @Override
    public List<ReactionCount> results() {
        return this.results;
    }

    @Override
    @Nullable
    public List<MessagePeerReaction> recentReactions() {
        return this.recentReactions;
    }

    public final ImmutableMessageReactions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageReactions(value, this.flags, this.min, this.canSeeList, this.results, this.recentReactions);
    }

    public final ImmutableMessageReactions withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageReactions(this.identifier, value, this.min, this.canSeeList, this.results, this.recentReactions);
    }

    public final ImmutableMessageReactions withMin(boolean value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutableMessageReactions(this.identifier, this.flags, value, this.canSeeList, this.results, this.recentReactions);
    }

    public final ImmutableMessageReactions withCanSeeList(boolean value) {
        if (this.canSeeList == value) {
            return this;
        }
        return new ImmutableMessageReactions(this.identifier, this.flags, this.min, value, this.results, this.recentReactions);
    }

    public final ImmutableMessageReactions withResults(ReactionCount ... elements) {
        List<ReactionCount> newValue = ImmutableMessageReactions.createUnmodifiableList(false, ImmutableMessageReactions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageReactions(this.identifier, this.flags, this.min, this.canSeeList, newValue, this.recentReactions);
    }

    public final ImmutableMessageReactions withResults(Iterable<? extends ReactionCount> elements) {
        if (this.results == elements) {
            return this;
        }
        List<ReactionCount> newValue = ImmutableMessageReactions.createUnmodifiableList(false, ImmutableMessageReactions.createSafeList(elements, true, false));
        return new ImmutableMessageReactions(this.identifier, this.flags, this.min, this.canSeeList, newValue, this.recentReactions);
    }

    public final ImmutableMessageReactions withRecentReactions(MessagePeerReaction ... elements) {
        if (elements == null) {
            return new ImmutableMessageReactions(this.identifier, this.flags, this.min, this.canSeeList, this.results, null);
        }
        List<MessagePeerReaction> newValue = Arrays.asList(elements) == null ? null : ImmutableMessageReactions.createUnmodifiableList(false, ImmutableMessageReactions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageReactions(this.identifier, this.flags, this.min, this.canSeeList, this.results, newValue);
    }

    public final ImmutableMessageReactions withRecentReactions(@Nullable Iterable<? extends MessagePeerReaction> elements) {
        if (this.recentReactions == elements) {
            return this;
        }
        List<MessagePeerReaction> newValue = elements == null ? null : ImmutableMessageReactions.createUnmodifiableList(false, ImmutableMessageReactions.createSafeList(elements, true, false));
        return new ImmutableMessageReactions(this.identifier, this.flags, this.min, this.canSeeList, this.results, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReactions && this.equalTo(0, (ImmutableMessageReactions)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReactions another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.min == another.min && this.canSeeList == another.canSeeList && this.results.equals(another.results) && Objects.equals(this.recentReactions, another.recentReactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.min);
        h += (h << 5) + Boolean.hashCode(this.canSeeList);
        h += (h << 5) + this.results.hashCode();
        h += (h << 5) + Objects.hashCode(this.recentReactions);
        return h;
    }

    public String toString() {
        return "MessageReactions{identifier=" + this.identifier + ", flags=" + this.flags + ", min=" + this.min + ", canSeeList=" + this.canSeeList + ", results=" + this.results + ", recentReactions=" + this.recentReactions + "}";
    }

    public static ImmutableMessageReactions copyOf(MessageReactions instance) {
        if (instance instanceof ImmutableMessageReactions) {
            return (ImmutableMessageReactions)instance;
        }
        return ImmutableMessageReactions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MIN = 4L;
        private static final long OPT_BIT_CAN_SEE_LIST = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean min;
        private boolean canSeeList;
        private List<ReactionCount> results = new ArrayList<ReactionCount>();
        private List<MessagePeerReaction> recentReactions = null;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageReactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageReactions) {
                instance = (MessageReactions)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.canSeeList(instance.canSeeList());
                List<MessagePeerReaction> recentReactionsValue = instance.recentReactions();
                if (recentReactionsValue != null) {
                    this.addAllRecentReactions(recentReactionsValue);
                }
                this.min(instance.min());
                this.addAllResults(instance.results());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder min(boolean min) {
            this.min = min;
            this.optBits |= 4L;
            return this;
        }

        public final Builder canSeeList(boolean canSeeList) {
            this.canSeeList = canSeeList;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addResult(ReactionCount element) {
            this.results.add(Objects.requireNonNull(element, "results element"));
            return this;
        }

        public final Builder addResults(ReactionCount ... elements) {
            for (ReactionCount element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            return this;
        }

        public final Builder results(Iterable<? extends ReactionCount> elements) {
            this.results.clear();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends ReactionCount> elements) {
            for (ReactionCount reactionCount : elements) {
                this.results.add(Objects.requireNonNull(reactionCount, "results element"));
            }
            return this;
        }

        public final Builder addRecentReaction(MessagePeerReaction element) {
            if (this.recentReactions == null) {
                this.recentReactions = new ArrayList<MessagePeerReaction>();
            }
            this.recentReactions.add(Objects.requireNonNull(element, "recentReactions element"));
            return this;
        }

        public final Builder addRecentReactions(MessagePeerReaction ... elements) {
            if (this.recentReactions == null) {
                this.recentReactions = new ArrayList<MessagePeerReaction>();
            }
            for (MessagePeerReaction element : elements) {
                this.recentReactions.add(Objects.requireNonNull(element, "recentReactions element"));
            }
            return this;
        }

        public final Builder recentReactions(@Nullable Iterable<? extends MessagePeerReaction> elements) {
            if (elements == null) {
                this.recentReactions = null;
                return this;
            }
            this.recentReactions = new ArrayList<MessagePeerReaction>();
            return this.addAllRecentReactions(elements);
        }

        public final Builder addAllRecentReactions(Iterable<? extends MessagePeerReaction> elements) {
            Objects.requireNonNull(elements, "recentReactions element");
            if (this.recentReactions == null) {
                this.recentReactions = new ArrayList<MessagePeerReaction>();
            }
            for (MessagePeerReaction messagePeerReaction : elements) {
                this.recentReactions.add(Objects.requireNonNull(messagePeerReaction, "recentReactions element"));
            }
            return this;
        }

        public ImmutableMessageReactions build() {
            return new ImmutableMessageReactions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean minIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean canSeeListIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte minBuildStage = 0;
        private boolean min;
        private byte canSeeListBuildStage = 0;
        private boolean canSeeList;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageReactions.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageReactions.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean min() {
            if (this.minBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBuildStage == 0) {
                this.minBuildStage = (byte)-1;
                this.min = ImmutableMessageReactions.this.minInitialize();
                this.minBuildStage = 1;
            }
            return this.min;
        }

        void min(boolean min) {
            this.min = min;
            this.minBuildStage = 1;
        }

        boolean canSeeList() {
            if (this.canSeeListBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSeeListBuildStage == 0) {
                this.canSeeListBuildStage = (byte)-1;
                this.canSeeList = ImmutableMessageReactions.this.canSeeListInitialize();
                this.canSeeListBuildStage = 1;
            }
            return this.canSeeList;
        }

        void canSeeList(boolean canSeeList) {
            this.canSeeList = canSeeList;
            this.canSeeListBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.minBuildStage == -1) {
                attributes.add("min");
            }
            if (this.canSeeListBuildStage == -1) {
                attributes.add("canSeeList");
            }
            return "Cannot build MessageReactions, attribute initializers form cycle " + attributes;
        }
    }
}

