/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageReplies;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageReplies
implements MessageReplies {
    private final int identifier;
    private final int flags;
    private final boolean comments;
    private final int replies;
    private final int repliesPts;
    @Nullable
    private final List<Peer> recentRepliers;
    @Nullable
    private final Long channelId;
    @Nullable
    private final Integer maxId;
    @Nullable
    private final Integer readMaxId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReplies(int replies, int repliesPts) {
        this.replies = replies;
        this.repliesPts = repliesPts;
        this.recentRepliers = null;
        this.channelId = null;
        this.maxId = null;
        this.readMaxId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.comments = this.initShim.comments();
        this.initShim = null;
    }

    private ImmutableMessageReplies(Builder builder) {
        this.replies = builder.replies;
        this.repliesPts = builder.repliesPts;
        this.recentRepliers = builder.recentRepliers == null ? null : ImmutableMessageReplies.createUnmodifiableList(true, builder.recentRepliers);
        this.channelId = builder.channelId;
        this.maxId = builder.maxId;
        this.readMaxId = builder.readMaxId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.commentsIsSet()) {
            this.initShim.comments(builder.comments);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.comments = this.initShim.comments();
        this.initShim = null;
    }

    private ImmutableMessageReplies(int identifier, int flags, boolean comments, int replies, int repliesPts, @Nullable List<Peer> recentRepliers, @Nullable Long channelId, @Nullable Integer maxId, @Nullable Integer readMaxId) {
        this.identifier = identifier;
        this.flags = flags;
        this.comments = comments;
        this.replies = replies;
        this.repliesPts = repliesPts;
        this.recentRepliers = recentRepliers;
        this.channelId = channelId;
        this.maxId = maxId;
        this.readMaxId = readMaxId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageReplies.super.identifier();
    }

    private int flagsInitialize() {
        return MessageReplies.super.flags();
    }

    private boolean commentsInitialize() {
        return MessageReplies.super.comments();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean comments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.comments() : this.comments;
    }

    @Override
    public int replies() {
        return this.replies;
    }

    @Override
    public int repliesPts() {
        return this.repliesPts;
    }

    @Override
    @Nullable
    public List<Peer> recentRepliers() {
        return this.recentRepliers;
    }

    @Override
    @Nullable
    public Long channelId() {
        return this.channelId;
    }

    @Override
    @Nullable
    public Integer maxId() {
        return this.maxId;
    }

    @Override
    @Nullable
    public Integer readMaxId() {
        return this.readMaxId;
    }

    public final ImmutableMessageReplies withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageReplies(value, this.flags, this.comments, this.replies, this.repliesPts, this.recentRepliers, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, value, this.comments, this.replies, this.repliesPts, this.recentRepliers, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withComments(boolean value) {
        if (this.comments == value) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, this.flags, value, this.replies, this.repliesPts, this.recentRepliers, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withReplies(int value) {
        if (this.replies == value) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, value, this.repliesPts, this.recentRepliers, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withRepliesPts(int value) {
        if (this.repliesPts == value) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, value, this.recentRepliers, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withRecentRepliers(Peer ... elements) {
        if (elements == null) {
            return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, this.repliesPts, null, this.channelId, this.maxId, this.readMaxId);
        }
        List<Peer> newValue = Arrays.asList(elements) == null ? null : ImmutableMessageReplies.createUnmodifiableList(false, ImmutableMessageReplies.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, this.repliesPts, newValue, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withRecentRepliers(@Nullable Iterable<? extends Peer> elements) {
        if (this.recentRepliers == elements) {
            return this;
        }
        List<Peer> newValue = elements == null ? null : ImmutableMessageReplies.createUnmodifiableList(false, ImmutableMessageReplies.createSafeList(elements, true, false));
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, this.repliesPts, newValue, this.channelId, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withChannelId(@Nullable Long value) {
        if (Objects.equals(this.channelId, value)) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, this.repliesPts, this.recentRepliers, value, this.maxId, this.readMaxId);
    }

    public final ImmutableMessageReplies withMaxId(@Nullable Integer value) {
        if (Objects.equals(this.maxId, value)) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, this.repliesPts, this.recentRepliers, this.channelId, value, this.readMaxId);
    }

    public final ImmutableMessageReplies withReadMaxId(@Nullable Integer value) {
        if (Objects.equals(this.readMaxId, value)) {
            return this;
        }
        return new ImmutableMessageReplies(this.identifier, this.flags, this.comments, this.replies, this.repliesPts, this.recentRepliers, this.channelId, this.maxId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReplies && this.equalTo(0, (ImmutableMessageReplies)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReplies another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.comments == another.comments && this.replies == another.replies && this.repliesPts == another.repliesPts && Objects.equals(this.recentRepliers, another.recentRepliers) && Objects.equals(this.channelId, another.channelId) && Objects.equals(this.maxId, another.maxId) && Objects.equals(this.readMaxId, another.readMaxId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.comments);
        h += (h << 5) + this.replies;
        h += (h << 5) + this.repliesPts;
        h += (h << 5) + Objects.hashCode(this.recentRepliers);
        h += (h << 5) + Objects.hashCode(this.channelId);
        h += (h << 5) + Objects.hashCode(this.maxId);
        h += (h << 5) + Objects.hashCode(this.readMaxId);
        return h;
    }

    public String toString() {
        return "MessageReplies{identifier=" + this.identifier + ", flags=" + this.flags + ", comments=" + this.comments + ", replies=" + this.replies + ", repliesPts=" + this.repliesPts + ", recentRepliers=" + this.recentRepliers + ", channelId=" + this.channelId + ", maxId=" + this.maxId + ", readMaxId=" + this.readMaxId + "}";
    }

    public static ImmutableMessageReplies of(int replies, int repliesPts) {
        return new ImmutableMessageReplies(replies, repliesPts);
    }

    public static ImmutableMessageReplies copyOf(MessageReplies instance) {
        if (instance instanceof ImmutableMessageReplies) {
            return (ImmutableMessageReplies)instance;
        }
        return ImmutableMessageReplies.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_REPLIES = 1L;
        private static final long INIT_BIT_REPLIES_PTS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_COMMENTS = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean comments;
        private int replies;
        private int repliesPts;
        private List<Peer> recentRepliers = null;
        private Long channelId;
        private Integer maxId;
        private Integer readMaxId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageReplies instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageReplies) {
                Integer maxIdValue;
                instance = (MessageReplies)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((maxIdValue = instance.maxId()) != null) {
                    this.maxId(maxIdValue);
                }
                this.comments(instance.comments());
                this.replies(instance.replies());
                Integer readMaxIdValue = instance.readMaxId();
                if (readMaxIdValue != null) {
                    this.readMaxId(readMaxIdValue);
                }
                this.flags(instance.flags());
                List<Peer> recentRepliersValue = instance.recentRepliers();
                if (recentRepliersValue != null) {
                    this.addAllRecentRepliers(recentRepliersValue);
                }
                this.repliesPts(instance.repliesPts());
                Long channelIdValue = instance.channelId();
                if (channelIdValue != null) {
                    this.channelId(channelIdValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder comments(boolean comments) {
            this.comments = comments;
            this.optBits |= 4L;
            return this;
        }

        public final Builder replies(int replies) {
            this.replies = replies;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder repliesPts(int repliesPts) {
            this.repliesPts = repliesPts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRecentReplier(Peer element) {
            if (this.recentRepliers == null) {
                this.recentRepliers = new ArrayList<Peer>();
            }
            this.recentRepliers.add(Objects.requireNonNull(element, "recentRepliers element"));
            return this;
        }

        public final Builder addRecentRepliers(Peer ... elements) {
            if (this.recentRepliers == null) {
                this.recentRepliers = new ArrayList<Peer>();
            }
            for (Peer element : elements) {
                this.recentRepliers.add(Objects.requireNonNull(element, "recentRepliers element"));
            }
            return this;
        }

        public final Builder recentRepliers(@Nullable Iterable<? extends Peer> elements) {
            if (elements == null) {
                this.recentRepliers = null;
                return this;
            }
            this.recentRepliers = new ArrayList<Peer>();
            return this.addAllRecentRepliers(elements);
        }

        public final Builder addAllRecentRepliers(Iterable<? extends Peer> elements) {
            Objects.requireNonNull(elements, "recentRepliers element");
            if (this.recentRepliers == null) {
                this.recentRepliers = new ArrayList<Peer>();
            }
            for (Peer peer : elements) {
                this.recentRepliers.add(Objects.requireNonNull(peer, "recentRepliers element"));
            }
            return this;
        }

        public final Builder channelId(@Nullable Long channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Builder maxId(@Nullable Integer maxId) {
            this.maxId = maxId;
            return this;
        }

        public final Builder readMaxId(@Nullable Integer readMaxId) {
            this.readMaxId = readMaxId;
            return this;
        }

        public ImmutableMessageReplies build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageReplies(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean commentsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("replies");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repliesPts");
            }
            return "Cannot build MessageReplies, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte commentsBuildStage = 0;
        private boolean comments;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageReplies.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageReplies.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean comments() {
            if (this.commentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commentsBuildStage == 0) {
                this.commentsBuildStage = (byte)-1;
                this.comments = ImmutableMessageReplies.this.commentsInitialize();
                this.commentsBuildStage = 1;
            }
            return this.comments;
        }

        void comments(boolean comments) {
            this.comments = comments;
            this.commentsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.commentsBuildStage == -1) {
                attributes.add("comments");
            }
            return "Cannot build MessageReplies, attribute initializers form cycle " + attributes;
        }
    }
}

