/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageReplyHeader;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageReplyHeader
implements MessageReplyHeader {
    private final int identifier;
    private final int flags;
    private final boolean replyToScheduled;
    private final int replyToMsgId;
    @Nullable
    private final Peer replyToPeerId;
    @Nullable
    private final Integer replyToTopId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReplyHeader(int replyToMsgId) {
        this.replyToMsgId = replyToMsgId;
        this.replyToPeerId = null;
        this.replyToTopId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.replyToScheduled = this.initShim.replyToScheduled();
        this.initShim = null;
    }

    private ImmutableMessageReplyHeader(Builder builder) {
        this.replyToMsgId = builder.replyToMsgId;
        this.replyToPeerId = builder.replyToPeerId;
        this.replyToTopId = builder.replyToTopId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.replyToScheduledIsSet()) {
            this.initShim.replyToScheduled(builder.replyToScheduled);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.replyToScheduled = this.initShim.replyToScheduled();
        this.initShim = null;
    }

    private ImmutableMessageReplyHeader(int identifier, int flags, boolean replyToScheduled, int replyToMsgId, @Nullable Peer replyToPeerId, @Nullable Integer replyToTopId) {
        this.identifier = identifier;
        this.flags = flags;
        this.replyToScheduled = replyToScheduled;
        this.replyToMsgId = replyToMsgId;
        this.replyToPeerId = replyToPeerId;
        this.replyToTopId = replyToTopId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageReplyHeader.super.identifier();
    }

    private int flagsInitialize() {
        return MessageReplyHeader.super.flags();
    }

    private boolean replyToScheduledInitialize() {
        return MessageReplyHeader.super.replyToScheduled();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean replyToScheduled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.replyToScheduled() : this.replyToScheduled;
    }

    @Override
    public int replyToMsgId() {
        return this.replyToMsgId;
    }

    @Override
    @Nullable
    public Peer replyToPeerId() {
        return this.replyToPeerId;
    }

    @Override
    @Nullable
    public Integer replyToTopId() {
        return this.replyToTopId;
    }

    public final ImmutableMessageReplyHeader withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageReplyHeader(value, this.flags, this.replyToScheduled, this.replyToMsgId, this.replyToPeerId, this.replyToTopId);
    }

    public final ImmutableMessageReplyHeader withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageReplyHeader(this.identifier, value, this.replyToScheduled, this.replyToMsgId, this.replyToPeerId, this.replyToTopId);
    }

    public final ImmutableMessageReplyHeader withReplyToScheduled(boolean value) {
        if (this.replyToScheduled == value) {
            return this;
        }
        return new ImmutableMessageReplyHeader(this.identifier, this.flags, value, this.replyToMsgId, this.replyToPeerId, this.replyToTopId);
    }

    public final ImmutableMessageReplyHeader withReplyToMsgId(int value) {
        if (this.replyToMsgId == value) {
            return this;
        }
        return new ImmutableMessageReplyHeader(this.identifier, this.flags, this.replyToScheduled, value, this.replyToPeerId, this.replyToTopId);
    }

    public final ImmutableMessageReplyHeader withReplyToPeerId(@Nullable Peer value) {
        if (this.replyToPeerId == value) {
            return this;
        }
        return new ImmutableMessageReplyHeader(this.identifier, this.flags, this.replyToScheduled, this.replyToMsgId, value, this.replyToTopId);
    }

    public final ImmutableMessageReplyHeader withReplyToTopId(@Nullable Integer value) {
        if (Objects.equals(this.replyToTopId, value)) {
            return this;
        }
        return new ImmutableMessageReplyHeader(this.identifier, this.flags, this.replyToScheduled, this.replyToMsgId, this.replyToPeerId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReplyHeader && this.equalTo(0, (ImmutableMessageReplyHeader)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReplyHeader another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.replyToScheduled == another.replyToScheduled && this.replyToMsgId == another.replyToMsgId && Objects.equals(this.replyToPeerId, another.replyToPeerId) && Objects.equals(this.replyToTopId, another.replyToTopId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.replyToScheduled);
        h += (h << 5) + this.replyToMsgId;
        h += (h << 5) + Objects.hashCode(this.replyToPeerId);
        h += (h << 5) + Objects.hashCode(this.replyToTopId);
        return h;
    }

    public String toString() {
        return "MessageReplyHeader{identifier=" + this.identifier + ", flags=" + this.flags + ", replyToScheduled=" + this.replyToScheduled + ", replyToMsgId=" + this.replyToMsgId + ", replyToPeerId=" + this.replyToPeerId + ", replyToTopId=" + this.replyToTopId + "}";
    }

    public static ImmutableMessageReplyHeader of(int replyToMsgId) {
        return new ImmutableMessageReplyHeader(replyToMsgId);
    }

    public static ImmutableMessageReplyHeader copyOf(MessageReplyHeader instance) {
        if (instance instanceof ImmutableMessageReplyHeader) {
            return (ImmutableMessageReplyHeader)instance;
        }
        return ImmutableMessageReplyHeader.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REPLY_TO_MSG_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REPLY_TO_SCHEDULED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean replyToScheduled;
        private int replyToMsgId;
        private Peer replyToPeerId;
        private Integer replyToTopId;

        private Builder() {
        }

        public final Builder from(MessageReplyHeader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageReplyHeader instance;
            long bits = 0L;
            if (object instanceof MessageReplyHeader) {
                instance = (MessageReplyHeader)object;
                this.flags(instance.flags());
                Peer replyToPeerIdValue = instance.replyToPeerId();
                if (replyToPeerIdValue != null) {
                    this.replyToPeerId(replyToPeerIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.replyToMsgId(instance.replyToMsgId());
                this.replyToScheduled(instance.replyToScheduled());
                Integer replyToTopIdValue = instance.replyToTopId();
                if (replyToTopIdValue != null) {
                    this.replyToTopId(replyToTopIdValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder replyToScheduled(boolean replyToScheduled) {
            this.replyToScheduled = replyToScheduled;
            this.optBits |= 4L;
            return this;
        }

        public final Builder replyToMsgId(int replyToMsgId) {
            this.replyToMsgId = replyToMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder replyToPeerId(@Nullable Peer replyToPeerId) {
            this.replyToPeerId = replyToPeerId;
            return this;
        }

        public final Builder replyToTopId(@Nullable Integer replyToTopId) {
            this.replyToTopId = replyToTopId;
            return this;
        }

        public ImmutableMessageReplyHeader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageReplyHeader(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean replyToScheduledIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("replyToMsgId");
            }
            return "Cannot build MessageReplyHeader, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte replyToScheduledBuildStage = 0;
        private boolean replyToScheduled;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageReplyHeader.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageReplyHeader.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean replyToScheduled() {
            if (this.replyToScheduledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.replyToScheduledBuildStage == 0) {
                this.replyToScheduledBuildStage = (byte)-1;
                this.replyToScheduled = ImmutableMessageReplyHeader.this.replyToScheduledInitialize();
                this.replyToScheduledBuildStage = 1;
            }
            return this.replyToScheduled;
        }

        void replyToScheduled(boolean replyToScheduled) {
            this.replyToScheduled = replyToScheduled;
            this.replyToScheduledBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.replyToScheduledBuildStage == -1) {
                attributes.add("replyToScheduled");
            }
            return "Cannot build MessageReplyHeader, attribute initializers form cycle " + attributes;
        }
    }
}

