/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseMessageFields;
import telegram4j.tl.Message;
import telegram4j.tl.MessageAction;
import telegram4j.tl.MessageFwdHeader;
import telegram4j.tl.MessageReplyHeader;
import telegram4j.tl.MessageService;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageService
implements MessageService {
    @Nullable
    private final MessageFwdHeader fwdFrom;
    private final int identifier;
    private final int flags;
    private final boolean out;
    private final boolean mentioned;
    private final boolean mediaUnread;
    private final boolean silent;
    private final boolean post;
    private final boolean legacy;
    private final int id;
    @Nullable
    private final Peer fromId;
    private final Peer peerId;
    @Nullable
    private final MessageReplyHeader replyTo;
    private final int date;
    private final MessageAction action;
    @Nullable
    private final Integer ttlPeriod;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageService(int id, Peer peerId, int date, MessageAction action) {
        this.id = id;
        this.peerId = Objects.requireNonNull(peerId, "peerId");
        this.date = date;
        this.action = Objects.requireNonNull(action, "action");
        this.fwdFrom = null;
        this.fromId = null;
        this.replyTo = null;
        this.ttlPeriod = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.mentioned = this.initShim.mentioned();
        this.mediaUnread = this.initShim.mediaUnread();
        this.silent = this.initShim.silent();
        this.post = this.initShim.post();
        this.legacy = this.initShim.legacy();
        this.initShim = null;
    }

    private ImmutableMessageService(Builder builder) {
        this.fwdFrom = builder.fwdFrom;
        this.id = builder.id;
        this.fromId = builder.fromId;
        this.peerId = builder.peerId;
        this.replyTo = builder.replyTo;
        this.date = builder.date;
        this.action = builder.action;
        this.ttlPeriod = builder.ttlPeriod;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.outIsSet()) {
            this.initShim.out(builder.out);
        }
        if (builder.mentionedIsSet()) {
            this.initShim.mentioned(builder.mentioned);
        }
        if (builder.mediaUnreadIsSet()) {
            this.initShim.mediaUnread(builder.mediaUnread);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.postIsSet()) {
            this.initShim.post(builder.post);
        }
        if (builder.legacyIsSet()) {
            this.initShim.legacy(builder.legacy);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.mentioned = this.initShim.mentioned();
        this.mediaUnread = this.initShim.mediaUnread();
        this.silent = this.initShim.silent();
        this.post = this.initShim.post();
        this.legacy = this.initShim.legacy();
        this.initShim = null;
    }

    private ImmutableMessageService(@Nullable MessageFwdHeader fwdFrom, int identifier, int flags, boolean out, boolean mentioned, boolean mediaUnread, boolean silent, boolean post, boolean legacy, int id, @Nullable Peer fromId, Peer peerId, @Nullable MessageReplyHeader replyTo, int date, MessageAction action, @Nullable Integer ttlPeriod) {
        this.fwdFrom = fwdFrom;
        this.identifier = identifier;
        this.flags = flags;
        this.out = out;
        this.mentioned = mentioned;
        this.mediaUnread = mediaUnread;
        this.silent = silent;
        this.post = post;
        this.legacy = legacy;
        this.id = id;
        this.fromId = fromId;
        this.peerId = peerId;
        this.replyTo = replyTo;
        this.date = date;
        this.action = action;
        this.ttlPeriod = ttlPeriod;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageService.super.identifier();
    }

    private int flagsInitialize() {
        return MessageService.super.flags();
    }

    private boolean outInitialize() {
        return MessageService.super.out();
    }

    private boolean mentionedInitialize() {
        return MessageService.super.mentioned();
    }

    private boolean mediaUnreadInitialize() {
        return MessageService.super.mediaUnread();
    }

    private boolean silentInitialize() {
        return MessageService.super.silent();
    }

    private boolean postInitialize() {
        return MessageService.super.post();
    }

    private boolean legacyInitialize() {
        return MessageService.super.legacy();
    }

    @Override
    @Nullable
    public MessageFwdHeader fwdFrom() {
        return this.fwdFrom;
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean out() {
        InitShim shim = this.initShim;
        return shim != null ? shim.out() : this.out;
    }

    @Override
    public boolean mentioned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mentioned() : this.mentioned;
    }

    @Override
    public boolean mediaUnread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mediaUnread() : this.mediaUnread;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean post() {
        InitShim shim = this.initShim;
        return shim != null ? shim.post() : this.post;
    }

    @Override
    public boolean legacy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.legacy() : this.legacy;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @Nullable
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    public Peer peerId() {
        return this.peerId;
    }

    @Override
    @Nullable
    public MessageReplyHeader replyTo() {
        return this.replyTo;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public MessageAction action() {
        return this.action;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    public final ImmutableMessageService withFwdFrom(@Nullable MessageFwdHeader value) {
        if (this.fwdFrom == value) {
            return this;
        }
        return new ImmutableMessageService(value, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, value, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, value, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withOut(boolean value) {
        if (this.out == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, value, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withMentioned(boolean value) {
        if (this.mentioned == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, value, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withMediaUnread(boolean value) {
        if (this.mediaUnread == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, value, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, value, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withPost(boolean value) {
        if (this.post == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, value, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withLegacy(boolean value) {
        if (this.legacy == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, value, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, value, this.fromId, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withFromId(@Nullable Peer value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, value, this.peerId, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withPeerId(Peer value) {
        if (this.peerId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peerId");
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, newValue, this.replyTo, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withReplyTo(@Nullable MessageReplyHeader value) {
        if (this.replyTo == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, value, this.date, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, value, this.action, this.ttlPeriod);
    }

    public final ImmutableMessageService withAction(MessageAction value) {
        if (this.action == value) {
            return this;
        }
        MessageAction newValue = Objects.requireNonNull(value, "action");
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, newValue, this.ttlPeriod);
    }

    public final ImmutableMessageService withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableMessageService(this.fwdFrom, this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.legacy, this.id, this.fromId, this.peerId, this.replyTo, this.date, this.action, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageService && this.equalTo(0, (ImmutableMessageService)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageService another) {
        return Objects.equals(this.fwdFrom, another.fwdFrom) && this.identifier == another.identifier && this.flags == another.flags && this.out == another.out && this.mentioned == another.mentioned && this.mediaUnread == another.mediaUnread && this.silent == another.silent && this.post == another.post && this.legacy == another.legacy && this.id == another.id && Objects.equals(this.fromId, another.fromId) && this.peerId.equals(another.peerId) && Objects.equals(this.replyTo, another.replyTo) && this.date == another.date && this.action.equals(another.action) && Objects.equals(this.ttlPeriod, another.ttlPeriod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.fwdFrom);
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.out);
        h += (h << 5) + Boolean.hashCode(this.mentioned);
        h += (h << 5) + Boolean.hashCode(this.mediaUnread);
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.post);
        h += (h << 5) + Boolean.hashCode(this.legacy);
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.fromId);
        h += (h << 5) + this.peerId.hashCode();
        h += (h << 5) + Objects.hashCode(this.replyTo);
        h += (h << 5) + this.date;
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        return h;
    }

    public String toString() {
        return "MessageService{fwdFrom=" + this.fwdFrom + ", identifier=" + this.identifier + ", flags=" + this.flags + ", out=" + this.out + ", mentioned=" + this.mentioned + ", mediaUnread=" + this.mediaUnread + ", silent=" + this.silent + ", post=" + this.post + ", legacy=" + this.legacy + ", id=" + this.id + ", fromId=" + this.fromId + ", peerId=" + this.peerId + ", replyTo=" + this.replyTo + ", date=" + this.date + ", action=" + this.action + ", ttlPeriod=" + this.ttlPeriod + "}";
    }

    public static ImmutableMessageService of(int id, Peer peerId, int date, MessageAction action) {
        return new ImmutableMessageService(id, peerId, date, action);
    }

    public static ImmutableMessageService copyOf(MessageService instance) {
        if (instance instanceof ImmutableMessageService) {
            return (ImmutableMessageService)instance;
        }
        return ImmutableMessageService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PEER_ID = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ACTION = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_OUT = 4L;
        private static final long OPT_BIT_MENTIONED = 8L;
        private static final long OPT_BIT_MEDIA_UNREAD = 16L;
        private static final long OPT_BIT_SILENT = 32L;
        private static final long OPT_BIT_POST = 64L;
        private static final long OPT_BIT_LEGACY = 128L;
        private long initBits = 15L;
        private long optBits;
        private MessageFwdHeader fwdFrom;
        private int identifier;
        private int flags;
        private boolean out;
        private boolean mentioned;
        private boolean mediaUnread;
        private boolean silent;
        private boolean post;
        private boolean legacy;
        private int id;
        private Peer fromId;
        private Peer peerId;
        private MessageReplyHeader replyTo;
        private int date;
        private MessageAction action;
        private Integer ttlPeriod;

        private Builder() {
        }

        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageService instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseMessageFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer ttlPeriodValue;
            MessageReplyHeader replyToValue;
            MessageFwdHeader fwdFromValue;
            Peer fromIdValue;
            Message instance;
            long bits = 0L;
            if (object instanceof Message) {
                instance = (Message)object;
                if ((bits & 0x20L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 4L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x2000L;
                }
            }
            if (object instanceof MessageService) {
                instance = (MessageService)object;
                if ((bits & 1L) == 0L) {
                    this.peerId(instance.peerId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.date(instance.date());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.silent(instance.silent());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.legacy(instance.legacy());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    fromIdValue = instance.fromId();
                    if (fromIdValue != null) {
                        this.fromId(fromIdValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.out(instance.out());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.mediaUnread(instance.mediaUnread());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    fwdFromValue = instance.fwdFrom();
                    if (fwdFromValue != null) {
                        this.fwdFrom(fwdFromValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.post(instance.post());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    replyToValue = instance.replyTo();
                    if (replyToValue != null) {
                        this.replyTo(replyToValue);
                    }
                    bits |= 0x800L;
                }
                this.action(instance.action());
                if ((bits & 0x1000L) == 0L) {
                    ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.mentioned(instance.mentioned());
                    bits |= 0x4000L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 4L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 4L;
                }
            }
            if (object instanceof BaseMessageFields) {
                instance = (BaseMessageFields)object;
                if ((bits & 1L) == 0L) {
                    this.peerId(instance.peerId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.date(instance.date());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.silent(instance.silent());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.legacy(instance.legacy());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    fromIdValue = instance.fromId();
                    if (fromIdValue != null) {
                        this.fromId(fromIdValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.out(instance.out());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.mediaUnread(instance.mediaUnread());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    fwdFromValue = instance.fwdFrom();
                    if (fwdFromValue != null) {
                        this.fwdFrom(fwdFromValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.post(instance.post());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    replyToValue = instance.replyTo();
                    if (replyToValue != null) {
                        this.replyTo(replyToValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.mentioned(instance.mentioned());
                    bits |= 0x4000L;
                }
            }
        }

        public final Builder fwdFrom(@Nullable MessageFwdHeader fwdFrom) {
            this.fwdFrom = fwdFrom;
            return this;
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder out(boolean out) {
            this.out = out;
            this.optBits |= 4L;
            return this;
        }

        public final Builder mentioned(boolean mentioned) {
            this.mentioned = mentioned;
            this.optBits |= 8L;
            return this;
        }

        public final Builder mediaUnread(boolean mediaUnread) {
            this.mediaUnread = mediaUnread;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder post(boolean post) {
            this.post = post;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder legacy(boolean legacy) {
            this.legacy = legacy;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromId(@Nullable Peer fromId) {
            this.fromId = fromId;
            return this;
        }

        public final Builder peerId(Peer peerId) {
            this.peerId = Objects.requireNonNull(peerId, "peerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder replyTo(@Nullable MessageReplyHeader replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder action(MessageAction action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public ImmutableMessageService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageService(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean outIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean mentionedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean mediaUnreadIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean postIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean legacyIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peerId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build MessageService, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte outBuildStage = 0;
        private boolean out;
        private byte mentionedBuildStage = 0;
        private boolean mentioned;
        private byte mediaUnreadBuildStage = 0;
        private boolean mediaUnread;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte postBuildStage = 0;
        private boolean post;
        private byte legacyBuildStage = 0;
        private boolean legacy;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageService.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageService.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean out() {
            if (this.outBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outBuildStage == 0) {
                this.outBuildStage = (byte)-1;
                this.out = ImmutableMessageService.this.outInitialize();
                this.outBuildStage = 1;
            }
            return this.out;
        }

        void out(boolean out) {
            this.out = out;
            this.outBuildStage = 1;
        }

        boolean mentioned() {
            if (this.mentionedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mentionedBuildStage == 0) {
                this.mentionedBuildStage = (byte)-1;
                this.mentioned = ImmutableMessageService.this.mentionedInitialize();
                this.mentionedBuildStage = 1;
            }
            return this.mentioned;
        }

        void mentioned(boolean mentioned) {
            this.mentioned = mentioned;
            this.mentionedBuildStage = 1;
        }

        boolean mediaUnread() {
            if (this.mediaUnreadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mediaUnreadBuildStage == 0) {
                this.mediaUnreadBuildStage = (byte)-1;
                this.mediaUnread = ImmutableMessageService.this.mediaUnreadInitialize();
                this.mediaUnreadBuildStage = 1;
            }
            return this.mediaUnread;
        }

        void mediaUnread(boolean mediaUnread) {
            this.mediaUnread = mediaUnread;
            this.mediaUnreadBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableMessageService.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean post() {
            if (this.postBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.postBuildStage == 0) {
                this.postBuildStage = (byte)-1;
                this.post = ImmutableMessageService.this.postInitialize();
                this.postBuildStage = 1;
            }
            return this.post;
        }

        void post(boolean post) {
            this.post = post;
            this.postBuildStage = 1;
        }

        boolean legacy() {
            if (this.legacyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.legacyBuildStage == 0) {
                this.legacyBuildStage = (byte)-1;
                this.legacy = ImmutableMessageService.this.legacyInitialize();
                this.legacyBuildStage = 1;
            }
            return this.legacy;
        }

        void legacy(boolean legacy) {
            this.legacy = legacy;
            this.legacyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.outBuildStage == -1) {
                attributes.add("out");
            }
            if (this.mentionedBuildStage == -1) {
                attributes.add("mentioned");
            }
            if (this.mediaUnreadBuildStage == -1) {
                attributes.add("mediaUnread");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.postBuildStage == -1) {
                attributes.add("post");
            }
            if (this.legacyBuildStage == -1) {
                attributes.add("legacy");
            }
            return "Cannot build MessageService, attribute initializers form cycle " + attributes;
        }
    }
}

