/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import telegram4j.tl.MessageUserVote;
import telegram4j.tl.MessageUserVoteMultiple;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageUserVoteMultiple
implements MessageUserVoteMultiple {
    private final int identifier;
    private final long userId;
    private final List<ByteBuf> options;
    private final int date;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageUserVoteMultiple(long userId, int date) {
        this.userId = userId;
        this.date = date;
        this.options = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableMessageUserVoteMultiple(Builder builder) {
        this.userId = builder.userId;
        this.options = builder.options_build();
        this.date = builder.date;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableMessageUserVoteMultiple(int identifier, long userId, List<ByteBuf> options, int date) {
        this.identifier = identifier;
        this.userId = userId;
        this.options = options;
        this.date = date;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageUserVoteMultiple.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public List<ByteBuf> options() {
        return this.options.stream().map(ByteBuf::duplicate).collect(Collectors.toList());
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableMessageUserVoteMultiple withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageUserVoteMultiple(value, this.userId, this.options, this.date);
    }

    public final ImmutableMessageUserVoteMultiple withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableMessageUserVoteMultiple(this.identifier, value, this.options, this.date);
    }

    public ImmutableMessageUserVoteMultiple withOptions(Iterable<? extends ByteBuf> value) {
        List<ByteBuf> newValue = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
        if (this.options == newValue) {
            return this;
        }
        return new ImmutableMessageUserVoteMultiple(this.identifier, this.userId, newValue, this.date);
    }

    public final ImmutableMessageUserVoteMultiple withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableMessageUserVoteMultiple(this.identifier, this.userId, this.options, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageUserVoteMultiple && this.equalTo(0, (ImmutableMessageUserVoteMultiple)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageUserVoteMultiple another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.options().equals(another.options()) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.options().hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "MessageUserVoteMultiple{identifier=" + this.identifier + ", userId=" + this.userId + ", options=" + this.options.stream().map(ByteBufUtil::hexDump).collect(Collectors.joining(", ", "[", "]")) + ", date=" + this.date + "}";
    }

    public static ImmutableMessageUserVoteMultiple of(long userId, int date) {
        return new ImmutableMessageUserVoteMultiple(userId, date);
    }

    public static ImmutableMessageUserVoteMultiple copyOf(MessageUserVoteMultiple instance) {
        if (instance instanceof ImmutableMessageUserVoteMultiple) {
            return (ImmutableMessageUserVoteMultiple)instance;
        }
        return ImmutableMessageUserVoteMultiple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private List<ByteBuf> options_value = null;
        private int identifier;
        private long userId;
        private int date;

        private Builder() {
        }

        public final Builder from(MessageUserVoteMultiple instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageUserVote instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageUserVote instance;
            long bits = 0L;
            if (object instanceof MessageUserVoteMultiple) {
                instance = (MessageUserVoteMultiple)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                this.options(instance.options());
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 4L;
                }
            }
            if (object instanceof MessageUserVote) {
                instance = (MessageUserVote)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder addOption(ByteBuf value) {
            this.options_getOrCreate().add(TlEncodingUtil.copyAsUnpooled((ByteBuf)value));
            return this;
        }

        public Builder addAllOptions(Iterable<? extends ByteBuf> value) {
            this.options_getOrCreate().addAll(StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder addAllOptions(ByteBuf ... value) {
            this.options_getOrCreate().addAll(Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder options(Iterable<? extends ByteBuf> value) {
            this.options_value = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public Builder options(ByteBuf ... value) {
            this.options_value = Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMessageUserVoteMultiple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageUserVoteMultiple(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build MessageUserVoteMultiple, some of required attributes are not set " + attributes;
        }

        private List<ByteBuf> options_build() {
            return TlEncodingUtil.unmodifiableList(this.options_value);
        }

        private List<ByteBuf> options_getOrCreate() {
            if (this.options_value == null) {
                this.options_value = new ArrayList<ByteBuf>();
            }
            return this.options_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageUserVoteMultiple.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build MessageUserVoteMultiple, attribute initializers form cycle " + attributes;
        }
    }
}

