/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageReplies;
import telegram4j.tl.MessageViews;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageViews
implements MessageViews {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer views;
    @Nullable
    private final Integer forwards;
    @Nullable
    private final MessageReplies replies;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableMessageViews INSTANCE = ImmutableMessageViews.validate(new ImmutableMessageViews());

    private ImmutableMessageViews() {
        this.views = null;
        this.forwards = null;
        this.replies = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageViews(Builder builder) {
        this.views = builder.views;
        this.forwards = builder.forwards;
        this.replies = builder.replies;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageViews(int identifier, int flags, @Nullable Integer views, @Nullable Integer forwards, @Nullable MessageReplies replies) {
        this.identifier = identifier;
        this.flags = flags;
        this.views = views;
        this.forwards = forwards;
        this.replies = replies;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageViews.super.identifier();
    }

    private int flagsInitialize() {
        return MessageViews.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer views() {
        return this.views;
    }

    @Override
    @Nullable
    public Integer forwards() {
        return this.forwards;
    }

    @Override
    @Nullable
    public MessageReplies replies() {
        return this.replies;
    }

    public final ImmutableMessageViews withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageViews.validate(new ImmutableMessageViews(value, this.flags, this.views, this.forwards, this.replies));
    }

    public final ImmutableMessageViews withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableMessageViews.validate(new ImmutableMessageViews(this.identifier, value, this.views, this.forwards, this.replies));
    }

    public final ImmutableMessageViews withViews(@Nullable Integer value) {
        if (Objects.equals(this.views, value)) {
            return this;
        }
        return ImmutableMessageViews.validate(new ImmutableMessageViews(this.identifier, this.flags, value, this.forwards, this.replies));
    }

    public final ImmutableMessageViews withForwards(@Nullable Integer value) {
        if (Objects.equals(this.forwards, value)) {
            return this;
        }
        return ImmutableMessageViews.validate(new ImmutableMessageViews(this.identifier, this.flags, this.views, value, this.replies));
    }

    public final ImmutableMessageViews withReplies(@Nullable MessageReplies value) {
        if (this.replies == value) {
            return this;
        }
        return ImmutableMessageViews.validate(new ImmutableMessageViews(this.identifier, this.flags, this.views, this.forwards, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageViews && this.equalTo(0, (ImmutableMessageViews)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageViews another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.views, another.views) && Objects.equals(this.forwards, another.forwards) && Objects.equals(this.replies, another.replies);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.views);
        h += (h << 5) + Objects.hashCode(this.forwards);
        h += (h << 5) + Objects.hashCode(this.replies);
        return h;
    }

    public String toString() {
        return "MessageViews{identifier=" + this.identifier + ", flags=" + this.flags + ", views=" + this.views + ", forwards=" + this.forwards + ", replies=" + this.replies + "}";
    }

    public static ImmutableMessageViews of() {
        return INSTANCE;
    }

    private static ImmutableMessageViews validate(ImmutableMessageViews instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageViews copyOf(MessageViews instance) {
        if (instance instanceof ImmutableMessageViews) {
            return (ImmutableMessageViews)instance;
        }
        return ImmutableMessageViews.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Integer views;
        private Integer forwards;
        private MessageReplies replies;

        private Builder() {
        }

        public final Builder from(MessageViews instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageViews instance;
            long bits = 0L;
            if (object instanceof MessageViews) {
                Integer viewsValue;
                MessageReplies repliesValue;
                instance = (MessageViews)object;
                Integer forwardsValue = instance.forwards();
                if (forwardsValue != null) {
                    this.forwards(forwardsValue);
                }
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((repliesValue = instance.replies()) != null) {
                    this.replies(repliesValue);
                }
                if ((viewsValue = instance.views()) != null) {
                    this.views(viewsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder views(@Nullable Integer views) {
            this.views = views;
            return this;
        }

        public final Builder forwards(@Nullable Integer forwards) {
            this.forwards = forwards;
            return this;
        }

        public final Builder replies(@Nullable MessageReplies replies) {
            this.replies = replies;
            return this;
        }

        public ImmutableMessageViews build() {
            return ImmutableMessageViews.validate(new ImmutableMessageViews(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageViews.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageViews.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build MessageViews, attribute initializers form cycle " + attributes;
        }
    }
}

