/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.NearestDc;
import telegram4j.tl.api.TlObject;

public final class ImmutableNearestDc
implements NearestDc {
    private final int identifier;
    private final String country;
    private final int thisDc;
    private final int nearestDc;

    private ImmutableNearestDc(String country, int thisDc, int nearestDc) {
        this.country = Objects.requireNonNull(country, "country");
        this.thisDc = thisDc;
        this.nearestDc = nearestDc;
        this.identifier = NearestDc.super.identifier();
    }

    private ImmutableNearestDc(Builder builder) {
        this.country = builder.country;
        this.thisDc = builder.thisDc;
        this.nearestDc = builder.nearestDc;
        this.identifier = builder.identifierIsSet() ? builder.identifier : NearestDc.super.identifier();
    }

    private ImmutableNearestDc(int identifier, String country, int thisDc, int nearestDc) {
        this.identifier = identifier;
        this.country = country;
        this.thisDc = thisDc;
        this.nearestDc = nearestDc;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String country() {
        return this.country;
    }

    @Override
    public int thisDc() {
        return this.thisDc;
    }

    @Override
    public int nearestDc() {
        return this.nearestDc;
    }

    public final ImmutableNearestDc withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableNearestDc(value, this.country, this.thisDc, this.nearestDc);
    }

    public final ImmutableNearestDc withCountry(String value) {
        String newValue = Objects.requireNonNull(value, "country");
        if (this.country.equals(newValue)) {
            return this;
        }
        return new ImmutableNearestDc(this.identifier, newValue, this.thisDc, this.nearestDc);
    }

    public final ImmutableNearestDc withThisDc(int value) {
        if (this.thisDc == value) {
            return this;
        }
        return new ImmutableNearestDc(this.identifier, this.country, value, this.nearestDc);
    }

    public final ImmutableNearestDc withNearestDc(int value) {
        if (this.nearestDc == value) {
            return this;
        }
        return new ImmutableNearestDc(this.identifier, this.country, this.thisDc, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNearestDc && this.equalTo(0, (ImmutableNearestDc)another);
    }

    private boolean equalTo(int synthetic, ImmutableNearestDc another) {
        return this.identifier == another.identifier && this.country.equals(another.country) && this.thisDc == another.thisDc && this.nearestDc == another.nearestDc;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.country.hashCode();
        h += (h << 5) + this.thisDc;
        h += (h << 5) + this.nearestDc;
        return h;
    }

    public String toString() {
        return "NearestDc{identifier=" + this.identifier + ", country=" + this.country + ", thisDc=" + this.thisDc + ", nearestDc=" + this.nearestDc + "}";
    }

    public static ImmutableNearestDc of(String country, int thisDc, int nearestDc) {
        return new ImmutableNearestDc(country, thisDc, nearestDc);
    }

    public static ImmutableNearestDc copyOf(NearestDc instance) {
        if (instance instanceof ImmutableNearestDc) {
            return (ImmutableNearestDc)instance;
        }
        return ImmutableNearestDc.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNTRY = 1L;
        private static final long INIT_BIT_THIS_DC = 2L;
        private static final long INIT_BIT_NEAREST_DC = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String country;
        private int thisDc;
        private int nearestDc;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NearestDc instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NearestDc) {
                instance = (NearestDc)object;
                this.thisDc(instance.thisDc());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.country(instance.country());
                this.nearestDc(instance.nearestDc());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder country(String country) {
            this.country = Objects.requireNonNull(country, "country");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder thisDc(int thisDc) {
            this.thisDc = thisDc;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nearestDc(int nearestDc) {
            this.nearestDc = nearestDc;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableNearestDc build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNearestDc(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("country");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("thisDc");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nearestDc");
            }
            return "Cannot build NearestDc, some of required attributes are not set " + attributes;
        }
    }
}

