/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.NotificationSound;
import telegram4j.tl.NotificationSoundDefault;
import telegram4j.tl.api.TlObject;

public final class ImmutableNotificationSoundDefault
implements NotificationSoundDefault {
    private final int identifier;
    private static final ImmutableNotificationSoundDefault INSTANCE = ImmutableNotificationSoundDefault.validate(new ImmutableNotificationSoundDefault());

    private ImmutableNotificationSoundDefault() {
        this.identifier = NotificationSoundDefault.super.identifier();
    }

    private ImmutableNotificationSoundDefault(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : NotificationSoundDefault.super.identifier();
    }

    private ImmutableNotificationSoundDefault(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableNotificationSoundDefault withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableNotificationSoundDefault.validate(new ImmutableNotificationSoundDefault(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotificationSoundDefault && this.equalTo(0, (ImmutableNotificationSoundDefault)another);
    }

    private boolean equalTo(int synthetic, ImmutableNotificationSoundDefault another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "NotificationSoundDefault{identifier=" + this.identifier + "}";
    }

    public static ImmutableNotificationSoundDefault of() {
        return INSTANCE;
    }

    private static ImmutableNotificationSoundDefault validate(ImmutableNotificationSoundDefault instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableNotificationSoundDefault copyOf(NotificationSoundDefault instance) {
        if (instance instanceof ImmutableNotificationSoundDefault) {
            return (ImmutableNotificationSoundDefault)instance;
        }
        return ImmutableNotificationSoundDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(NotificationSound instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NotificationSoundDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NotificationSound instance;
            long bits = 0L;
            if (object instanceof NotificationSound) {
                instance = (NotificationSound)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NotificationSoundDefault) {
                instance = (NotificationSoundDefault)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableNotificationSoundDefault build() {
            return ImmutableNotificationSoundDefault.validate(new ImmutableNotificationSoundDefault(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

