/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.NotificationSound;
import telegram4j.tl.NotificationSoundLocal;
import telegram4j.tl.api.TlObject;

public final class ImmutableNotificationSoundLocal
implements NotificationSoundLocal {
    private final int identifier;
    private final String title;
    private final String data;

    private ImmutableNotificationSoundLocal(String title, String data) {
        this.title = Objects.requireNonNull(title, "title");
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = NotificationSoundLocal.super.identifier();
    }

    private ImmutableNotificationSoundLocal(Builder builder) {
        this.title = builder.title;
        this.data = builder.data;
        this.identifier = builder.identifierIsSet() ? builder.identifier : NotificationSoundLocal.super.identifier();
    }

    private ImmutableNotificationSoundLocal(int identifier, String title, String data) {
        this.identifier = identifier;
        this.title = title;
        this.data = data;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String data() {
        return this.data;
    }

    public final ImmutableNotificationSoundLocal withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableNotificationSoundLocal(value, this.title, this.data);
    }

    public final ImmutableNotificationSoundLocal withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableNotificationSoundLocal(this.identifier, newValue, this.data);
    }

    public final ImmutableNotificationSoundLocal withData(String value) {
        String newValue = Objects.requireNonNull(value, "data");
        if (this.data.equals(newValue)) {
            return this;
        }
        return new ImmutableNotificationSoundLocal(this.identifier, this.title, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotificationSoundLocal && this.equalTo(0, (ImmutableNotificationSoundLocal)another);
    }

    private boolean equalTo(int synthetic, ImmutableNotificationSoundLocal another) {
        return this.identifier == another.identifier && this.title.equals(another.title) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "NotificationSoundLocal{identifier=" + this.identifier + ", title=" + this.title + ", data=" + this.data + "}";
    }

    public static ImmutableNotificationSoundLocal of(String title, String data) {
        return new ImmutableNotificationSoundLocal(title, data);
    }

    public static ImmutableNotificationSoundLocal copyOf(NotificationSoundLocal instance) {
        if (instance instanceof ImmutableNotificationSoundLocal) {
            return (ImmutableNotificationSoundLocal)instance;
        }
        return ImmutableNotificationSoundLocal.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_DATA = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String title;
        private String data;

        private Builder() {
        }

        public final Builder from(NotificationSound instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NotificationSoundLocal instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NotificationSound instance;
            long bits = 0L;
            if (object instanceof NotificationSound) {
                instance = (NotificationSound)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NotificationSoundLocal) {
                instance = (NotificationSoundLocal)object;
                this.data(instance.data());
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(String data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNotificationSoundLocal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNotificationSoundLocal(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build NotificationSoundLocal, some of required attributes are not set " + attributes;
        }
    }
}

