/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.NotificationSound;
import telegram4j.tl.NotificationSoundRingtone;
import telegram4j.tl.api.TlObject;

public final class ImmutableNotificationSoundRingtone
implements NotificationSoundRingtone {
    private final int identifier;
    private final long id;

    private ImmutableNotificationSoundRingtone(long id) {
        this.id = id;
        this.identifier = NotificationSoundRingtone.super.identifier();
    }

    private ImmutableNotificationSoundRingtone(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : NotificationSoundRingtone.super.identifier();
    }

    private ImmutableNotificationSoundRingtone(int identifier, long id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    public final ImmutableNotificationSoundRingtone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableNotificationSoundRingtone(value, this.id);
    }

    public final ImmutableNotificationSoundRingtone withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableNotificationSoundRingtone(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotificationSoundRingtone && this.equalTo(0, (ImmutableNotificationSoundRingtone)another);
    }

    private boolean equalTo(int synthetic, ImmutableNotificationSoundRingtone another) {
        return this.identifier == another.identifier && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        return h;
    }

    public String toString() {
        return "NotificationSoundRingtone{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableNotificationSoundRingtone of(long id) {
        return new ImmutableNotificationSoundRingtone(id);
    }

    public static ImmutableNotificationSoundRingtone copyOf(NotificationSoundRingtone instance) {
        if (instance instanceof ImmutableNotificationSoundRingtone) {
            return (ImmutableNotificationSoundRingtone)instance;
        }
        return ImmutableNotificationSoundRingtone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long id;

        private Builder() {
        }

        public final Builder from(NotificationSound instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NotificationSoundRingtone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NotificationSound instance;
            long bits = 0L;
            if (object instanceof NotificationSound) {
                instance = (NotificationSound)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NotificationSoundRingtone) {
                instance = (NotificationSoundRingtone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNotificationSoundRingtone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNotificationSoundRingtone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build NotificationSoundRingtone, some of required attributes are not set " + attributes;
        }
    }
}

