/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.NotifyBroadcasts;
import telegram4j.tl.NotifyPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableNotifyBroadcasts
implements NotifyBroadcasts {
    private final int identifier;
    private static final ImmutableNotifyBroadcasts INSTANCE = ImmutableNotifyBroadcasts.validate(new ImmutableNotifyBroadcasts());

    private ImmutableNotifyBroadcasts() {
        this.identifier = NotifyBroadcasts.super.identifier();
    }

    private ImmutableNotifyBroadcasts(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : NotifyBroadcasts.super.identifier();
    }

    private ImmutableNotifyBroadcasts(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableNotifyBroadcasts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableNotifyBroadcasts.validate(new ImmutableNotifyBroadcasts(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotifyBroadcasts && this.equalTo(0, (ImmutableNotifyBroadcasts)another);
    }

    private boolean equalTo(int synthetic, ImmutableNotifyBroadcasts another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "NotifyBroadcasts{identifier=" + this.identifier + "}";
    }

    public static ImmutableNotifyBroadcasts of() {
        return INSTANCE;
    }

    private static ImmutableNotifyBroadcasts validate(ImmutableNotifyBroadcasts instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableNotifyBroadcasts copyOf(NotifyBroadcasts instance) {
        if (instance instanceof ImmutableNotifyBroadcasts) {
            return (ImmutableNotifyBroadcasts)instance;
        }
        return ImmutableNotifyBroadcasts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(NotifyBroadcasts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NotifyPeer instance;
            long bits = 0L;
            if (object instanceof NotifyBroadcasts) {
                instance = (NotifyBroadcasts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NotifyPeer) {
                instance = (NotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableNotifyBroadcasts build() {
            return ImmutableNotifyBroadcasts.validate(new ImmutableNotifyBroadcasts(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

