/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.NotifyPeer;
import telegram4j.tl.NotifyUsers;
import telegram4j.tl.api.TlObject;

public final class ImmutableNotifyUsers
implements NotifyUsers {
    private final int identifier;
    private static final ImmutableNotifyUsers INSTANCE = ImmutableNotifyUsers.validate(new ImmutableNotifyUsers());

    private ImmutableNotifyUsers() {
        this.identifier = NotifyUsers.super.identifier();
    }

    private ImmutableNotifyUsers(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : NotifyUsers.super.identifier();
    }

    private ImmutableNotifyUsers(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableNotifyUsers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableNotifyUsers.validate(new ImmutableNotifyUsers(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotifyUsers && this.equalTo(0, (ImmutableNotifyUsers)another);
    }

    private boolean equalTo(int synthetic, ImmutableNotifyUsers another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "NotifyUsers{identifier=" + this.identifier + "}";
    }

    public static ImmutableNotifyUsers of() {
        return INSTANCE;
    }

    private static ImmutableNotifyUsers validate(ImmutableNotifyUsers instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableNotifyUsers copyOf(NotifyUsers instance) {
        if (instance instanceof ImmutableNotifyUsers) {
            return (ImmutableNotifyUsers)instance;
        }
        return ImmutableNotifyUsers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(NotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NotifyUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NotifyPeer instance;
            long bits = 0L;
            if (object instanceof NotifyPeer) {
                instance = (NotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NotifyUsers) {
                instance = (NotifyUsers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableNotifyUsers build() {
            return ImmutableNotifyUsers.validate(new ImmutableNotifyUsers(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

