/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Document;
import telegram4j.tl.Page;
import telegram4j.tl.PageBlock;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutablePage
implements Page {
    private final int identifier;
    private final int flags;
    private final boolean part;
    private final boolean rtl;
    private final boolean v2;
    private final String url;
    private final List<PageBlock> blocks;
    private final List<Photo> photos;
    private final List<Document> documents;
    @Nullable
    private final Integer views;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePage(String url) {
        this.url = Objects.requireNonNull(url, "url");
        this.blocks = Collections.emptyList();
        this.photos = Collections.emptyList();
        this.documents = Collections.emptyList();
        this.views = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.part = this.initShim.part();
        this.rtl = this.initShim.rtl();
        this.v2 = this.initShim.v2();
        this.initShim = null;
    }

    private ImmutablePage(Builder builder) {
        this.url = builder.url;
        this.blocks = ImmutablePage.createUnmodifiableList(true, builder.blocks);
        this.photos = ImmutablePage.createUnmodifiableList(true, builder.photos);
        this.documents = ImmutablePage.createUnmodifiableList(true, builder.documents);
        this.views = builder.views;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.partIsSet()) {
            this.initShim.part(builder.part);
        }
        if (builder.rtlIsSet()) {
            this.initShim.rtl(builder.rtl);
        }
        if (builder.v2IsSet()) {
            this.initShim.v2(builder.v2);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.part = this.initShim.part();
        this.rtl = this.initShim.rtl();
        this.v2 = this.initShim.v2();
        this.initShim = null;
    }

    private ImmutablePage(int identifier, int flags, boolean part, boolean rtl, boolean v2, String url, List<PageBlock> blocks, List<Photo> photos, List<Document> documents, @Nullable Integer views) {
        this.identifier = identifier;
        this.flags = flags;
        this.part = part;
        this.rtl = rtl;
        this.v2 = v2;
        this.url = url;
        this.blocks = blocks;
        this.photos = photos;
        this.documents = documents;
        this.views = views;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Page.super.identifier();
    }

    private int flagsInitialize() {
        return Page.super.flags();
    }

    private boolean partInitialize() {
        return Page.super.part();
    }

    private boolean rtlInitialize() {
        return Page.super.rtl();
    }

    private boolean v2Initialize() {
        return Page.super.v2();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean part() {
        InitShim shim = this.initShim;
        return shim != null ? shim.part() : this.part;
    }

    @Override
    public boolean rtl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rtl() : this.rtl;
    }

    @Override
    public boolean v2() {
        InitShim shim = this.initShim;
        return shim != null ? shim.v2() : this.v2;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public List<PageBlock> blocks() {
        return this.blocks;
    }

    @Override
    public List<Photo> photos() {
        return this.photos;
    }

    @Override
    public List<Document> documents() {
        return this.documents;
    }

    @Override
    @Nullable
    public Integer views() {
        return this.views;
    }

    public final ImmutablePage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePage(value, this.flags, this.part, this.rtl, this.v2, this.url, this.blocks, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePage(this.identifier, value, this.part, this.rtl, this.v2, this.url, this.blocks, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withPart(boolean value) {
        if (this.part == value) {
            return this;
        }
        return new ImmutablePage(this.identifier, this.flags, value, this.rtl, this.v2, this.url, this.blocks, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withRtl(boolean value) {
        if (this.rtl == value) {
            return this;
        }
        return new ImmutablePage(this.identifier, this.flags, this.part, value, this.v2, this.url, this.blocks, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withV2(boolean value) {
        if (this.v2 == value) {
            return this;
        }
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, value, this.url, this.blocks, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, newValue, this.blocks, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withBlocks(PageBlock ... elements) {
        List<PageBlock> newValue = ImmutablePage.createUnmodifiableList(false, ImmutablePage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, newValue, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withBlocks(Iterable<? extends PageBlock> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<PageBlock> newValue = ImmutablePage.createUnmodifiableList(false, ImmutablePage.createSafeList(elements, true, false));
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, newValue, this.photos, this.documents, this.views);
    }

    public final ImmutablePage withPhotos(Photo ... elements) {
        List<Photo> newValue = ImmutablePage.createUnmodifiableList(false, ImmutablePage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, this.blocks, newValue, this.documents, this.views);
    }

    public final ImmutablePage withPhotos(Iterable<? extends Photo> elements) {
        if (this.photos == elements) {
            return this;
        }
        List<Photo> newValue = ImmutablePage.createUnmodifiableList(false, ImmutablePage.createSafeList(elements, true, false));
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, this.blocks, newValue, this.documents, this.views);
    }

    public final ImmutablePage withDocuments(Document ... elements) {
        List<Document> newValue = ImmutablePage.createUnmodifiableList(false, ImmutablePage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, this.blocks, this.photos, newValue, this.views);
    }

    public final ImmutablePage withDocuments(Iterable<? extends Document> elements) {
        if (this.documents == elements) {
            return this;
        }
        List<Document> newValue = ImmutablePage.createUnmodifiableList(false, ImmutablePage.createSafeList(elements, true, false));
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, this.blocks, this.photos, newValue, this.views);
    }

    public final ImmutablePage withViews(@Nullable Integer value) {
        if (Objects.equals(this.views, value)) {
            return this;
        }
        return new ImmutablePage(this.identifier, this.flags, this.part, this.rtl, this.v2, this.url, this.blocks, this.photos, this.documents, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePage && this.equalTo(0, (ImmutablePage)another);
    }

    private boolean equalTo(int synthetic, ImmutablePage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.part == another.part && this.rtl == another.rtl && this.v2 == another.v2 && this.url.equals(another.url) && this.blocks.equals(another.blocks) && this.photos.equals(another.photos) && this.documents.equals(another.documents) && Objects.equals(this.views, another.views);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.part);
        h += (h << 5) + Boolean.hashCode(this.rtl);
        h += (h << 5) + Boolean.hashCode(this.v2);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.photos.hashCode();
        h += (h << 5) + this.documents.hashCode();
        h += (h << 5) + Objects.hashCode(this.views);
        return h;
    }

    public String toString() {
        return "Page{identifier=" + this.identifier + ", flags=" + this.flags + ", part=" + this.part + ", rtl=" + this.rtl + ", v2=" + this.v2 + ", url=" + this.url + ", blocks=" + this.blocks + ", photos=" + this.photos + ", documents=" + this.documents + ", views=" + this.views + "}";
    }

    public static ImmutablePage of(String url) {
        return new ImmutablePage(url);
    }

    public static ImmutablePage copyOf(Page instance) {
        if (instance instanceof ImmutablePage) {
            return (ImmutablePage)instance;
        }
        return ImmutablePage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PART = 4L;
        private static final long OPT_BIT_RTL = 8L;
        private static final long OPT_BIT_V2 = 16L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean part;
        private boolean rtl;
        private boolean v2;
        private String url;
        private List<PageBlock> blocks = new ArrayList<PageBlock>();
        private List<Photo> photos = new ArrayList<Photo>();
        private List<Document> documents = new ArrayList<Document>();
        private Integer views;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Page instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Page) {
                instance = (Page)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllDocuments(instance.documents());
                this.addAllBlocks(instance.blocks());
                this.part(instance.part());
                this.flags(instance.flags());
                this.rtl(instance.rtl());
                this.v2(instance.v2());
                this.addAllPhotos(instance.photos());
                this.url(instance.url());
                Integer viewsValue = instance.views();
                if (viewsValue != null) {
                    this.views(viewsValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder part(boolean part) {
            this.part = part;
            this.optBits |= 4L;
            return this;
        }

        public final Builder rtl(boolean rtl) {
            this.rtl = rtl;
            this.optBits |= 8L;
            return this;
        }

        public final Builder v2(boolean v2) {
            this.v2 = v2;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addBlock(PageBlock element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(PageBlock ... elements) {
            for (PageBlock element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder blocks(Iterable<? extends PageBlock> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends PageBlock> elements) {
            for (PageBlock pageBlock : elements) {
                this.blocks.add(Objects.requireNonNull(pageBlock, "blocks element"));
            }
            return this;
        }

        public final Builder addPhoto(Photo element) {
            this.photos.add(Objects.requireNonNull(element, "photos element"));
            return this;
        }

        public final Builder addPhotos(Photo ... elements) {
            for (Photo element : elements) {
                this.photos.add(Objects.requireNonNull(element, "photos element"));
            }
            return this;
        }

        public final Builder photos(Iterable<? extends Photo> elements) {
            this.photos.clear();
            return this.addAllPhotos(elements);
        }

        public final Builder addAllPhotos(Iterable<? extends Photo> elements) {
            for (Photo photo : elements) {
                this.photos.add(Objects.requireNonNull(photo, "photos element"));
            }
            return this;
        }

        public final Builder addDocument(Document element) {
            this.documents.add(Objects.requireNonNull(element, "documents element"));
            return this;
        }

        public final Builder addDocuments(Document ... elements) {
            for (Document element : elements) {
                this.documents.add(Objects.requireNonNull(element, "documents element"));
            }
            return this;
        }

        public final Builder documents(Iterable<? extends Document> elements) {
            this.documents.clear();
            return this.addAllDocuments(elements);
        }

        public final Builder addAllDocuments(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.documents.add(Objects.requireNonNull(document, "documents element"));
            }
            return this;
        }

        public final Builder views(@Nullable Integer views) {
            this.views = views;
            return this;
        }

        public ImmutablePage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean partIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean rtlIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean v2IsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build Page, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte partBuildStage = 0;
        private boolean part;
        private byte rtlBuildStage = 0;
        private boolean rtl;
        private byte v2BuildStage = 0;
        private boolean v2;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean part() {
            if (this.partBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partBuildStage == 0) {
                this.partBuildStage = (byte)-1;
                this.part = ImmutablePage.this.partInitialize();
                this.partBuildStage = 1;
            }
            return this.part;
        }

        void part(boolean part) {
            this.part = part;
            this.partBuildStage = 1;
        }

        boolean rtl() {
            if (this.rtlBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rtlBuildStage == 0) {
                this.rtlBuildStage = (byte)-1;
                this.rtl = ImmutablePage.this.rtlInitialize();
                this.rtlBuildStage = 1;
            }
            return this.rtl;
        }

        void rtl(boolean rtl) {
            this.rtl = rtl;
            this.rtlBuildStage = 1;
        }

        boolean v2() {
            if (this.v2BuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.v2BuildStage == 0) {
                this.v2BuildStage = (byte)-1;
                this.v2 = ImmutablePage.this.v2Initialize();
                this.v2BuildStage = 1;
            }
            return this.v2;
        }

        void v2(boolean v2) {
            this.v2 = v2;
            this.v2BuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.partBuildStage == -1) {
                attributes.add("part");
            }
            if (this.rtlBuildStage == -1) {
                attributes.add("rtl");
            }
            if (this.v2BuildStage == -1) {
                attributes.add("v2");
            }
            return "Cannot build Page, attribute initializers form cycle " + attributes;
        }
    }
}

