/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockAnchor;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockAnchor
implements PageBlockAnchor {
    private final int identifier;
    private final String name;

    private ImmutablePageBlockAnchor(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.identifier = PageBlockAnchor.super.identifier();
    }

    private ImmutablePageBlockAnchor(Builder builder) {
        this.name = builder.name;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockAnchor.super.identifier();
    }

    private ImmutablePageBlockAnchor(int identifier, String name) {
        this.identifier = identifier;
        this.name = name;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutablePageBlockAnchor withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockAnchor(value, this.name);
    }

    public final ImmutablePageBlockAnchor withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePageBlockAnchor(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockAnchor && this.equalTo(0, (ImmutablePageBlockAnchor)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockAnchor another) {
        return this.identifier == another.identifier && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockAnchor{identifier=" + this.identifier + ", name=" + this.name + "}";
    }

    public static ImmutablePageBlockAnchor of(String name) {
        return new ImmutablePageBlockAnchor(name);
    }

    public static ImmutablePageBlockAnchor copyOf(PageBlockAnchor instance) {
        if (instance instanceof ImmutablePageBlockAnchor) {
            return (ImmutablePageBlockAnchor)instance;
        }
        return ImmutablePageBlockAnchor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String name;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockAnchor instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockAnchor) {
                instance = (PageBlockAnchor)object;
                this.name(instance.name());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageBlockAnchor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockAnchor(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build PageBlockAnchor, some of required attributes are not set " + attributes;
        }
    }
}

