/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockAudio;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockAudio
implements PageBlockAudio {
    private final int identifier;
    private final long audioId;
    private final PageCaption caption;

    private ImmutablePageBlockAudio(long audioId, PageCaption caption) {
        this.audioId = audioId;
        this.caption = Objects.requireNonNull(caption, "caption");
        this.identifier = PageBlockAudio.super.identifier();
    }

    private ImmutablePageBlockAudio(Builder builder) {
        this.audioId = builder.audioId;
        this.caption = builder.caption;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockAudio.super.identifier();
    }

    private ImmutablePageBlockAudio(int identifier, long audioId, PageCaption caption) {
        this.identifier = identifier;
        this.audioId = audioId;
        this.caption = caption;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long audioId() {
        return this.audioId;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    public final ImmutablePageBlockAudio withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockAudio(value, this.audioId, this.caption);
    }

    public final ImmutablePageBlockAudio withAudioId(long value) {
        if (this.audioId == value) {
            return this;
        }
        return new ImmutablePageBlockAudio(this.identifier, value, this.caption);
    }

    public final ImmutablePageBlockAudio withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockAudio(this.identifier, this.audioId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockAudio && this.equalTo(0, (ImmutablePageBlockAudio)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockAudio another) {
        return this.identifier == another.identifier && this.audioId == another.audioId && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.audioId);
        h += (h << 5) + this.caption.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockAudio{identifier=" + this.identifier + ", audioId=" + this.audioId + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockAudio of(long audioId, PageCaption caption) {
        return new ImmutablePageBlockAudio(audioId, caption);
    }

    public static ImmutablePageBlockAudio copyOf(PageBlockAudio instance) {
        if (instance instanceof ImmutablePageBlockAudio) {
            return (ImmutablePageBlockAudio)instance;
        }
        return ImmutablePageBlockAudio.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_AUDIO_ID = 1L;
        private static final long INIT_BIT_CAPTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long audioId;
        private PageCaption caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockAudio instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockAudio) {
                instance = (PageBlockAudio)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.caption(instance.caption());
                this.audioId(instance.audioId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder audioId(long audioId) {
            this.audioId = audioId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageBlockAudio build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockAudio(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("audioId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockAudio, some of required attributes are not set " + attributes;
        }
    }
}

