/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockAuthorDate;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockAuthorDate
implements PageBlockAuthorDate {
    private final int identifier;
    private final RichText author;
    private final int publishedDate;

    private ImmutablePageBlockAuthorDate(RichText author, int publishedDate) {
        this.author = Objects.requireNonNull(author, "author");
        this.publishedDate = publishedDate;
        this.identifier = PageBlockAuthorDate.super.identifier();
    }

    private ImmutablePageBlockAuthorDate(Builder builder) {
        this.author = builder.author;
        this.publishedDate = builder.publishedDate;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockAuthorDate.super.identifier();
    }

    private ImmutablePageBlockAuthorDate(int identifier, RichText author, int publishedDate) {
        this.identifier = identifier;
        this.author = author;
        this.publishedDate = publishedDate;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText author() {
        return this.author;
    }

    @Override
    public int publishedDate() {
        return this.publishedDate;
    }

    public final ImmutablePageBlockAuthorDate withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockAuthorDate(value, this.author, this.publishedDate);
    }

    public final ImmutablePageBlockAuthorDate withAuthor(RichText value) {
        if (this.author == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "author");
        return new ImmutablePageBlockAuthorDate(this.identifier, newValue, this.publishedDate);
    }

    public final ImmutablePageBlockAuthorDate withPublishedDate(int value) {
        if (this.publishedDate == value) {
            return this;
        }
        return new ImmutablePageBlockAuthorDate(this.identifier, this.author, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockAuthorDate && this.equalTo(0, (ImmutablePageBlockAuthorDate)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockAuthorDate another) {
        return this.identifier == another.identifier && this.author.equals(another.author) && this.publishedDate == another.publishedDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.publishedDate;
        return h;
    }

    public String toString() {
        return "PageBlockAuthorDate{identifier=" + this.identifier + ", author=" + this.author + ", publishedDate=" + this.publishedDate + "}";
    }

    public static ImmutablePageBlockAuthorDate of(RichText author, int publishedDate) {
        return new ImmutablePageBlockAuthorDate(author, publishedDate);
    }

    public static ImmutablePageBlockAuthorDate copyOf(PageBlockAuthorDate instance) {
        if (instance instanceof ImmutablePageBlockAuthorDate) {
            return (ImmutablePageBlockAuthorDate)instance;
        }
        return ImmutablePageBlockAuthorDate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTHOR = 1L;
        private static final long INIT_BIT_PUBLISHED_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText author;
        private int publishedDate;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockAuthorDate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockAuthorDate) {
                instance = (PageBlockAuthorDate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.author(instance.author());
                this.publishedDate(instance.publishedDate());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder author(RichText author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder publishedDate(int publishedDate) {
            this.publishedDate = publishedDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageBlockAuthorDate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockAuthorDate(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("publishedDate");
            }
            return "Cannot build PageBlockAuthorDate, some of required attributes are not set " + attributes;
        }
    }
}

