/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockBlockquote;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockBlockquote
implements PageBlockBlockquote {
    private final int identifier;
    private final RichText text;
    private final RichText caption;

    private ImmutablePageBlockBlockquote(RichText text, RichText caption) {
        this.text = Objects.requireNonNull(text, "text");
        this.caption = Objects.requireNonNull(caption, "caption");
        this.identifier = PageBlockBlockquote.super.identifier();
    }

    private ImmutablePageBlockBlockquote(Builder builder) {
        this.text = builder.text;
        this.caption = builder.caption;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockBlockquote.super.identifier();
    }

    private ImmutablePageBlockBlockquote(int identifier, RichText text, RichText caption) {
        this.identifier = identifier;
        this.text = text;
        this.caption = caption;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public RichText caption() {
        return this.caption;
    }

    public final ImmutablePageBlockBlockquote withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockBlockquote(value, this.text, this.caption);
    }

    public final ImmutablePageBlockBlockquote withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutablePageBlockBlockquote(this.identifier, newValue, this.caption);
    }

    public final ImmutablePageBlockBlockquote withCaption(RichText value) {
        if (this.caption == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockBlockquote(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockBlockquote && this.equalTo(0, (ImmutablePageBlockBlockquote)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockBlockquote another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.caption.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockBlockquote{identifier=" + this.identifier + ", text=" + this.text + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockBlockquote of(RichText text, RichText caption) {
        return new ImmutablePageBlockBlockquote(text, caption);
    }

    public static ImmutablePageBlockBlockquote copyOf(PageBlockBlockquote instance) {
        if (instance instanceof ImmutablePageBlockBlockquote) {
            return (ImmutablePageBlockBlockquote)instance;
        }
        return ImmutablePageBlockBlockquote.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_CAPTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText text;
        private RichText caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockBlockquote instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockBlockquote) {
                instance = (PageBlockBlockquote)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.caption(instance.caption());
                this.text(instance.text());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder caption(RichText caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageBlockBlockquote build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockBlockquote(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockBlockquote, some of required attributes are not set " + attributes;
        }
    }
}

