/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockChannel;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockChannel
implements PageBlockChannel {
    private final int identifier;
    private final Chat channel;

    private ImmutablePageBlockChannel(Chat channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        this.identifier = PageBlockChannel.super.identifier();
    }

    private ImmutablePageBlockChannel(Builder builder) {
        this.channel = builder.channel;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockChannel.super.identifier();
    }

    private ImmutablePageBlockChannel(int identifier, Chat channel) {
        this.identifier = identifier;
        this.channel = channel;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Chat channel() {
        return this.channel;
    }

    public final ImmutablePageBlockChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockChannel(value, this.channel);
    }

    public final ImmutablePageBlockChannel withChannel(Chat value) {
        if (this.channel == value) {
            return this;
        }
        Chat newValue = Objects.requireNonNull(value, "channel");
        return new ImmutablePageBlockChannel(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockChannel && this.equalTo(0, (ImmutablePageBlockChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockChannel another) {
        return this.identifier == another.identifier && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockChannel{identifier=" + this.identifier + ", channel=" + this.channel + "}";
    }

    public static ImmutablePageBlockChannel of(Chat channel) {
        return new ImmutablePageBlockChannel(channel);
    }

    public static ImmutablePageBlockChannel copyOf(PageBlockChannel instance) {
        if (instance instanceof ImmutablePageBlockChannel) {
            return (ImmutablePageBlockChannel)instance;
        }
        return ImmutablePageBlockChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Chat channel;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockChannel) {
                instance = (PageBlockChannel)object;
                this.channel(instance.channel());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channel(Chat channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageBlockChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build PageBlockChannel, some of required attributes are not set " + attributes;
        }
    }
}

