/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockCollage;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockCollage
implements PageBlockCollage {
    private final int identifier;
    private final List<PageBlock> items;
    private final PageCaption caption;

    private ImmutablePageBlockCollage(PageCaption caption) {
        this.caption = Objects.requireNonNull(caption, "caption");
        this.items = Collections.emptyList();
        this.identifier = PageBlockCollage.super.identifier();
    }

    private ImmutablePageBlockCollage(Builder builder) {
        this.items = ImmutablePageBlockCollage.createUnmodifiableList(true, builder.items);
        this.caption = builder.caption;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockCollage.super.identifier();
    }

    private ImmutablePageBlockCollage(int identifier, List<PageBlock> items, PageCaption caption) {
        this.identifier = identifier;
        this.items = items;
        this.caption = caption;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PageBlock> items() {
        return this.items;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    public final ImmutablePageBlockCollage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockCollage(value, this.items, this.caption);
    }

    public final ImmutablePageBlockCollage withItems(PageBlock ... elements) {
        List<PageBlock> newValue = ImmutablePageBlockCollage.createUnmodifiableList(false, ImmutablePageBlockCollage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageBlockCollage(this.identifier, newValue, this.caption);
    }

    public final ImmutablePageBlockCollage withItems(Iterable<? extends PageBlock> elements) {
        if (this.items == elements) {
            return this;
        }
        List<PageBlock> newValue = ImmutablePageBlockCollage.createUnmodifiableList(false, ImmutablePageBlockCollage.createSafeList(elements, true, false));
        return new ImmutablePageBlockCollage(this.identifier, newValue, this.caption);
    }

    public final ImmutablePageBlockCollage withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockCollage(this.identifier, this.items, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockCollage && this.equalTo(0, (ImmutablePageBlockCollage)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockCollage another) {
        return this.identifier == another.identifier && this.items.equals(another.items) && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.items.hashCode();
        h += (h << 5) + this.caption.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockCollage{identifier=" + this.identifier + ", items=" + this.items + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockCollage of(PageCaption caption) {
        return new ImmutablePageBlockCollage(caption);
    }

    public static ImmutablePageBlockCollage copyOf(PageBlockCollage instance) {
        if (instance instanceof ImmutablePageBlockCollage) {
            return (ImmutablePageBlockCollage)instance;
        }
        return ImmutablePageBlockCollage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CAPTION = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<PageBlock> items = new ArrayList<PageBlock>();
        private PageCaption caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockCollage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockCollage) {
                instance = (PageBlockCollage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.caption(instance.caption());
                this.addAllItems(instance.items());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addItem(PageBlock element) {
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        public final Builder addItems(PageBlock ... elements) {
            for (PageBlock element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        public final Builder items(Iterable<? extends PageBlock> elements) {
            this.items.clear();
            return this.addAllItems(elements);
        }

        public final Builder addAllItems(Iterable<? extends PageBlock> elements) {
            for (PageBlock pageBlock : elements) {
                this.items.add(Objects.requireNonNull(pageBlock, "items element"));
            }
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageBlockCollage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockCollage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockCollage, some of required attributes are not set " + attributes;
        }
    }
}

