/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockCover;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockCover
implements PageBlockCover {
    private final int identifier;
    private final PageBlock cover;

    private ImmutablePageBlockCover(PageBlock cover) {
        this.cover = Objects.requireNonNull(cover, "cover");
        this.identifier = PageBlockCover.super.identifier();
    }

    private ImmutablePageBlockCover(Builder builder) {
        this.cover = builder.cover;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockCover.super.identifier();
    }

    private ImmutablePageBlockCover(int identifier, PageBlock cover) {
        this.identifier = identifier;
        this.cover = cover;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public PageBlock cover() {
        return this.cover;
    }

    public final ImmutablePageBlockCover withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockCover(value, this.cover);
    }

    public final ImmutablePageBlockCover withCover(PageBlock value) {
        if (this.cover == value) {
            return this;
        }
        PageBlock newValue = Objects.requireNonNull(value, "cover");
        return new ImmutablePageBlockCover(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockCover && this.equalTo(0, (ImmutablePageBlockCover)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockCover another) {
        return this.identifier == another.identifier && this.cover.equals(another.cover);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.cover.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockCover{identifier=" + this.identifier + ", cover=" + this.cover + "}";
    }

    public static ImmutablePageBlockCover of(PageBlock cover) {
        return new ImmutablePageBlockCover(cover);
    }

    public static ImmutablePageBlockCover copyOf(PageBlockCover instance) {
        if (instance instanceof ImmutablePageBlockCover) {
            return (ImmutablePageBlockCover)instance;
        }
        return ImmutablePageBlockCover.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COVER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private PageBlock cover;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockCover instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockCover) {
                instance = (PageBlockCover)object;
                this.cover(instance.cover());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder cover(PageBlock cover) {
            this.cover = Objects.requireNonNull(cover, "cover");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageBlockCover build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockCover(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cover");
            }
            return "Cannot build PageBlockCover, some of required attributes are not set " + attributes;
        }
    }
}

