/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockDetails;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockDetails
implements PageBlockDetails {
    private final int identifier;
    private final int flags;
    private final boolean open;
    private final List<PageBlock> blocks;
    private final RichText title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageBlockDetails(RichText title) {
        this.title = Objects.requireNonNull(title, "title");
        this.blocks = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.open = this.initShim.open();
        this.initShim = null;
    }

    private ImmutablePageBlockDetails(Builder builder) {
        this.blocks = ImmutablePageBlockDetails.createUnmodifiableList(true, builder.blocks);
        this.title = builder.title;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.openIsSet()) {
            this.initShim.open(builder.open);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.open = this.initShim.open();
        this.initShim = null;
    }

    private ImmutablePageBlockDetails(int identifier, int flags, boolean open, List<PageBlock> blocks, RichText title) {
        this.identifier = identifier;
        this.flags = flags;
        this.open = open;
        this.blocks = blocks;
        this.title = title;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageBlockDetails.super.identifier();
    }

    private int flagsInitialize() {
        return PageBlockDetails.super.flags();
    }

    private boolean openInitialize() {
        return PageBlockDetails.super.open();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean open() {
        InitShim shim = this.initShim;
        return shim != null ? shim.open() : this.open;
    }

    @Override
    public List<PageBlock> blocks() {
        return this.blocks;
    }

    @Override
    public RichText title() {
        return this.title;
    }

    public final ImmutablePageBlockDetails withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockDetails(value, this.flags, this.open, this.blocks, this.title);
    }

    public final ImmutablePageBlockDetails withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePageBlockDetails(this.identifier, value, this.open, this.blocks, this.title);
    }

    public final ImmutablePageBlockDetails withOpen(boolean value) {
        if (this.open == value) {
            return this;
        }
        return new ImmutablePageBlockDetails(this.identifier, this.flags, value, this.blocks, this.title);
    }

    public final ImmutablePageBlockDetails withBlocks(PageBlock ... elements) {
        List<PageBlock> newValue = ImmutablePageBlockDetails.createUnmodifiableList(false, ImmutablePageBlockDetails.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageBlockDetails(this.identifier, this.flags, this.open, newValue, this.title);
    }

    public final ImmutablePageBlockDetails withBlocks(Iterable<? extends PageBlock> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<PageBlock> newValue = ImmutablePageBlockDetails.createUnmodifiableList(false, ImmutablePageBlockDetails.createSafeList(elements, true, false));
        return new ImmutablePageBlockDetails(this.identifier, this.flags, this.open, newValue, this.title);
    }

    public final ImmutablePageBlockDetails withTitle(RichText value) {
        if (this.title == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "title");
        return new ImmutablePageBlockDetails(this.identifier, this.flags, this.open, this.blocks, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockDetails && this.equalTo(0, (ImmutablePageBlockDetails)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockDetails another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.open == another.open && this.blocks.equals(another.blocks) && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.open);
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockDetails{identifier=" + this.identifier + ", flags=" + this.flags + ", open=" + this.open + ", blocks=" + this.blocks + ", title=" + this.title + "}";
    }

    public static ImmutablePageBlockDetails of(RichText title) {
        return new ImmutablePageBlockDetails(title);
    }

    public static ImmutablePageBlockDetails copyOf(PageBlockDetails instance) {
        if (instance instanceof ImmutablePageBlockDetails) {
            return (ImmutablePageBlockDetails)instance;
        }
        return ImmutablePageBlockDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_OPEN = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean open;
        private List<PageBlock> blocks = new ArrayList<PageBlock>();
        private RichText title;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockDetails) {
                instance = (PageBlockDetails)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.title(instance.title());
                this.addAllBlocks(instance.blocks());
                this.open(instance.open());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder open(boolean open) {
            this.open = open;
            this.optBits |= 4L;
            return this;
        }

        public final Builder addBlock(PageBlock element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(PageBlock ... elements) {
            for (PageBlock element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder blocks(Iterable<? extends PageBlock> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends PageBlock> elements) {
            for (PageBlock pageBlock : elements) {
                this.blocks.add(Objects.requireNonNull(pageBlock, "blocks element"));
            }
            return this;
        }

        public final Builder title(RichText title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageBlockDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockDetails(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean openIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build PageBlockDetails, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte openBuildStage = 0;
        private boolean open;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageBlockDetails.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageBlockDetails.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean open() {
            if (this.openBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.openBuildStage == 0) {
                this.openBuildStage = (byte)-1;
                this.open = ImmutablePageBlockDetails.this.openInitialize();
                this.openBuildStage = 1;
            }
            return this.open;
        }

        void open(boolean open) {
            this.open = open;
            this.openBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.openBuildStage == -1) {
                attributes.add("open");
            }
            return "Cannot build PageBlockDetails, attribute initializers form cycle " + attributes;
        }
    }
}

