/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockDivider;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockDivider
implements PageBlockDivider {
    private final int identifier;
    private static final ImmutablePageBlockDivider INSTANCE = ImmutablePageBlockDivider.validate(new ImmutablePageBlockDivider());

    private ImmutablePageBlockDivider() {
        this.identifier = PageBlockDivider.super.identifier();
    }

    private ImmutablePageBlockDivider(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockDivider.super.identifier();
    }

    private ImmutablePageBlockDivider(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutablePageBlockDivider withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePageBlockDivider.validate(new ImmutablePageBlockDivider(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockDivider && this.equalTo(0, (ImmutablePageBlockDivider)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockDivider another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "PageBlockDivider{identifier=" + this.identifier + "}";
    }

    public static ImmutablePageBlockDivider of() {
        return INSTANCE;
    }

    private static ImmutablePageBlockDivider validate(ImmutablePageBlockDivider instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePageBlockDivider copyOf(PageBlockDivider instance) {
        if (instance instanceof ImmutablePageBlockDivider) {
            return (ImmutablePageBlockDivider)instance;
        }
        return ImmutablePageBlockDivider.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockDivider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockDivider) {
                instance = (PageBlockDivider)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePageBlockDivider build() {
            return ImmutablePageBlockDivider.validate(new ImmutablePageBlockDivider(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

