/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockEmbed;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockEmbed
implements PageBlockEmbed {
    private final int identifier;
    private final int flags;
    private final boolean fullWidth;
    private final boolean allowScrolling;
    @Nullable
    private final String url;
    @Nullable
    private final String html;
    @Nullable
    private final Long posterPhotoId;
    @Nullable
    private final Integer w;
    @Nullable
    private final Integer h;
    private final PageCaption caption;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageBlockEmbed(PageCaption caption) {
        this.caption = Objects.requireNonNull(caption, "caption");
        this.url = null;
        this.html = null;
        this.posterPhotoId = null;
        this.w = null;
        this.h = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.fullWidth = this.initShim.fullWidth();
        this.allowScrolling = this.initShim.allowScrolling();
        this.initShim = null;
    }

    private ImmutablePageBlockEmbed(Builder builder) {
        this.url = builder.url;
        this.html = builder.html;
        this.posterPhotoId = builder.posterPhotoId;
        this.w = builder.w;
        this.h = builder.h;
        this.caption = builder.caption;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.fullWidthIsSet()) {
            this.initShim.fullWidth(builder.fullWidth);
        }
        if (builder.allowScrollingIsSet()) {
            this.initShim.allowScrolling(builder.allowScrolling);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.fullWidth = this.initShim.fullWidth();
        this.allowScrolling = this.initShim.allowScrolling();
        this.initShim = null;
    }

    private ImmutablePageBlockEmbed(int identifier, int flags, boolean fullWidth, boolean allowScrolling, @Nullable String url, @Nullable String html, @Nullable Long posterPhotoId, @Nullable Integer w, @Nullable Integer h, PageCaption caption) {
        this.identifier = identifier;
        this.flags = flags;
        this.fullWidth = fullWidth;
        this.allowScrolling = allowScrolling;
        this.url = url;
        this.html = html;
        this.posterPhotoId = posterPhotoId;
        this.w = w;
        this.h = h;
        this.caption = caption;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageBlockEmbed.super.identifier();
    }

    private int flagsInitialize() {
        return PageBlockEmbed.super.flags();
    }

    private boolean fullWidthInitialize() {
        return PageBlockEmbed.super.fullWidth();
    }

    private boolean allowScrollingInitialize() {
        return PageBlockEmbed.super.allowScrolling();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean fullWidth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fullWidth() : this.fullWidth;
    }

    @Override
    public boolean allowScrolling() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowScrolling() : this.allowScrolling;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public String html() {
        return this.html;
    }

    @Override
    @Nullable
    public Long posterPhotoId() {
        return this.posterPhotoId;
    }

    @Override
    @Nullable
    public Integer w() {
        return this.w;
    }

    @Override
    @Nullable
    public Integer h() {
        return this.h;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    public final ImmutablePageBlockEmbed withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockEmbed(value, this.flags, this.fullWidth, this.allowScrolling, this.url, this.html, this.posterPhotoId, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, value, this.fullWidth, this.allowScrolling, this.url, this.html, this.posterPhotoId, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withFullWidth(boolean value) {
        if (this.fullWidth == value) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, value, this.allowScrolling, this.url, this.html, this.posterPhotoId, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withAllowScrolling(boolean value) {
        if (this.allowScrolling == value) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, value, this.url, this.html, this.posterPhotoId, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, this.allowScrolling, value, this.html, this.posterPhotoId, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withHtml(@Nullable String value) {
        if (Objects.equals(this.html, value)) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, this.allowScrolling, this.url, value, this.posterPhotoId, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withPosterPhotoId(@Nullable Long value) {
        if (Objects.equals(this.posterPhotoId, value)) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, this.allowScrolling, this.url, this.html, value, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withW(@Nullable Integer value) {
        if (Objects.equals(this.w, value)) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, this.allowScrolling, this.url, this.html, this.posterPhotoId, value, this.h, this.caption);
    }

    public final ImmutablePageBlockEmbed withH(@Nullable Integer value) {
        if (Objects.equals(this.h, value)) {
            return this;
        }
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, this.allowScrolling, this.url, this.html, this.posterPhotoId, this.w, value, this.caption);
    }

    public final ImmutablePageBlockEmbed withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockEmbed(this.identifier, this.flags, this.fullWidth, this.allowScrolling, this.url, this.html, this.posterPhotoId, this.w, this.h, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockEmbed && this.equalTo(0, (ImmutablePageBlockEmbed)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockEmbed another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.fullWidth == another.fullWidth && this.allowScrolling == another.allowScrolling && Objects.equals(this.url, another.url) && Objects.equals(this.html, another.html) && Objects.equals(this.posterPhotoId, another.posterPhotoId) && Objects.equals(this.w, another.w) && Objects.equals(this.h, another.h) && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.flags;
        h$$ += (h$$ << 5) + Boolean.hashCode(this.fullWidth);
        h$$ += (h$$ << 5) + Boolean.hashCode(this.allowScrolling);
        h$$ += (h$$ << 5) + Objects.hashCode(this.url);
        h$$ += (h$$ << 5) + Objects.hashCode(this.html);
        h$$ += (h$$ << 5) + Objects.hashCode(this.posterPhotoId);
        h$$ += (h$$ << 5) + Objects.hashCode(this.w);
        h$$ += (h$$ << 5) + Objects.hashCode(this.h);
        h$$ += (h$$ << 5) + this.caption.hashCode();
        return h$$;
    }

    public String toString() {
        return "PageBlockEmbed{identifier=" + this.identifier + ", flags=" + this.flags + ", fullWidth=" + this.fullWidth + ", allowScrolling=" + this.allowScrolling + ", url=" + this.url + ", html=" + this.html + ", posterPhotoId=" + this.posterPhotoId + ", w=" + this.w + ", h=" + this.h + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockEmbed of(PageCaption caption) {
        return new ImmutablePageBlockEmbed(caption);
    }

    public static ImmutablePageBlockEmbed copyOf(PageBlockEmbed instance) {
        if (instance instanceof ImmutablePageBlockEmbed) {
            return (ImmutablePageBlockEmbed)instance;
        }
        return ImmutablePageBlockEmbed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CAPTION = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_FULL_WIDTH = 4L;
        private static final long OPT_BIT_ALLOW_SCROLLING = 8L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean fullWidth;
        private boolean allowScrolling;
        private String url;
        private String html;
        private Long posterPhotoId;
        private Integer w;
        private Integer h;
        private PageCaption caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockEmbed instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockEmbed) {
                Long posterPhotoIdValue;
                String urlValue;
                instance = (PageBlockEmbed)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fullWidth(instance.fullWidth());
                this.allowScrolling(instance.allowScrolling());
                Integer wValue = instance.w();
                if (wValue != null) {
                    this.w(wValue);
                }
                this.flags(instance.flags());
                Integer hValue = instance.h();
                if (hValue != null) {
                    this.h(hValue);
                }
                this.caption(instance.caption());
                String htmlValue = instance.html();
                if (htmlValue != null) {
                    this.html(htmlValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((posterPhotoIdValue = instance.posterPhotoId()) != null) {
                    this.posterPhotoId(posterPhotoIdValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder fullWidth(boolean fullWidth) {
            this.fullWidth = fullWidth;
            this.optBits |= 4L;
            return this;
        }

        public final Builder allowScrolling(boolean allowScrolling) {
            this.allowScrolling = allowScrolling;
            this.optBits |= 8L;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder html(@Nullable String html) {
            this.html = html;
            return this;
        }

        public final Builder posterPhotoId(@Nullable Long posterPhotoId) {
            this.posterPhotoId = posterPhotoId;
            return this;
        }

        public final Builder w(@Nullable Integer w) {
            this.w = w;
            return this;
        }

        public final Builder h(@Nullable Integer h) {
            this.h = h;
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageBlockEmbed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockEmbed(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean fullWidthIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean allowScrollingIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockEmbed, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte fullWidthBuildStage = 0;
        private boolean fullWidth;
        private byte allowScrollingBuildStage = 0;
        private boolean allowScrolling;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageBlockEmbed.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageBlockEmbed.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean fullWidth() {
            if (this.fullWidthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fullWidthBuildStage == 0) {
                this.fullWidthBuildStage = (byte)-1;
                this.fullWidth = ImmutablePageBlockEmbed.this.fullWidthInitialize();
                this.fullWidthBuildStage = 1;
            }
            return this.fullWidth;
        }

        void fullWidth(boolean fullWidth) {
            this.fullWidth = fullWidth;
            this.fullWidthBuildStage = 1;
        }

        boolean allowScrolling() {
            if (this.allowScrollingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowScrollingBuildStage == 0) {
                this.allowScrollingBuildStage = (byte)-1;
                this.allowScrolling = ImmutablePageBlockEmbed.this.allowScrollingInitialize();
                this.allowScrollingBuildStage = 1;
            }
            return this.allowScrolling;
        }

        void allowScrolling(boolean allowScrolling) {
            this.allowScrolling = allowScrolling;
            this.allowScrollingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.fullWidthBuildStage == -1) {
                attributes.add("fullWidth");
            }
            if (this.allowScrollingBuildStage == -1) {
                attributes.add("allowScrolling");
            }
            return "Cannot build PageBlockEmbed, attribute initializers form cycle " + attributes;
        }
    }
}

