/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockEmbedPost;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockEmbedPost
implements PageBlockEmbedPost {
    private final int identifier;
    private final String url;
    private final long webpageId;
    private final long authorPhotoId;
    private final String author;
    private final int date;
    private final List<PageBlock> blocks;
    private final PageCaption caption;

    private ImmutablePageBlockEmbedPost(String url, long webpageId, long authorPhotoId, String author, int date, PageCaption caption) {
        this.url = Objects.requireNonNull(url, "url");
        this.webpageId = webpageId;
        this.authorPhotoId = authorPhotoId;
        this.author = Objects.requireNonNull(author, "author");
        this.date = date;
        this.caption = Objects.requireNonNull(caption, "caption");
        this.blocks = Collections.emptyList();
        this.identifier = PageBlockEmbedPost.super.identifier();
    }

    private ImmutablePageBlockEmbedPost(Builder builder) {
        this.url = builder.url;
        this.webpageId = builder.webpageId;
        this.authorPhotoId = builder.authorPhotoId;
        this.author = builder.author;
        this.date = builder.date;
        this.blocks = ImmutablePageBlockEmbedPost.createUnmodifiableList(true, builder.blocks);
        this.caption = builder.caption;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockEmbedPost.super.identifier();
    }

    private ImmutablePageBlockEmbedPost(int identifier, String url, long webpageId, long authorPhotoId, String author, int date, List<PageBlock> blocks, PageCaption caption) {
        this.identifier = identifier;
        this.url = url;
        this.webpageId = webpageId;
        this.authorPhotoId = authorPhotoId;
        this.author = author;
        this.date = date;
        this.blocks = blocks;
        this.caption = caption;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public long webpageId() {
        return this.webpageId;
    }

    @Override
    public long authorPhotoId() {
        return this.authorPhotoId;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public List<PageBlock> blocks() {
        return this.blocks;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    public final ImmutablePageBlockEmbedPost withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockEmbedPost(value, this.url, this.webpageId, this.authorPhotoId, this.author, this.date, this.blocks, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutablePageBlockEmbedPost(this.identifier, newValue, this.webpageId, this.authorPhotoId, this.author, this.date, this.blocks, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withWebpageId(long value) {
        if (this.webpageId == value) {
            return this;
        }
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, value, this.authorPhotoId, this.author, this.date, this.blocks, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withAuthorPhotoId(long value) {
        if (this.authorPhotoId == value) {
            return this;
        }
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, this.webpageId, value, this.author, this.date, this.blocks, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, this.webpageId, this.authorPhotoId, newValue, this.date, this.blocks, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, this.webpageId, this.authorPhotoId, this.author, value, this.blocks, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withBlocks(PageBlock ... elements) {
        List<PageBlock> newValue = ImmutablePageBlockEmbedPost.createUnmodifiableList(false, ImmutablePageBlockEmbedPost.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, this.webpageId, this.authorPhotoId, this.author, this.date, newValue, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withBlocks(Iterable<? extends PageBlock> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<PageBlock> newValue = ImmutablePageBlockEmbedPost.createUnmodifiableList(false, ImmutablePageBlockEmbedPost.createSafeList(elements, true, false));
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, this.webpageId, this.authorPhotoId, this.author, this.date, newValue, this.caption);
    }

    public final ImmutablePageBlockEmbedPost withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockEmbedPost(this.identifier, this.url, this.webpageId, this.authorPhotoId, this.author, this.date, this.blocks, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockEmbedPost && this.equalTo(0, (ImmutablePageBlockEmbedPost)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockEmbedPost another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.webpageId == another.webpageId && this.authorPhotoId == another.authorPhotoId && this.author.equals(another.author) && this.date == another.date && this.blocks.equals(another.blocks) && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Long.hashCode(this.webpageId);
        h += (h << 5) + Long.hashCode(this.authorPhotoId);
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.caption.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockEmbedPost{identifier=" + this.identifier + ", url=" + this.url + ", webpageId=" + this.webpageId + ", authorPhotoId=" + this.authorPhotoId + ", author=" + this.author + ", date=" + this.date + ", blocks=" + this.blocks + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockEmbedPost of(String url, long webpageId, long authorPhotoId, String author, int date, PageCaption caption) {
        return new ImmutablePageBlockEmbedPost(url, webpageId, authorPhotoId, author, date, caption);
    }

    public static ImmutablePageBlockEmbedPost copyOf(PageBlockEmbedPost instance) {
        if (instance instanceof ImmutablePageBlockEmbedPost) {
            return (ImmutablePageBlockEmbedPost)instance;
        }
        return ImmutablePageBlockEmbedPost.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_WEBPAGE_ID = 2L;
        private static final long INIT_BIT_AUTHOR_PHOTO_ID = 4L;
        private static final long INIT_BIT_AUTHOR = 8L;
        private static final long INIT_BIT_DATE = 16L;
        private static final long INIT_BIT_CAPTION = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private String url;
        private long webpageId;
        private long authorPhotoId;
        private String author;
        private int date;
        private List<PageBlock> blocks = new ArrayList<PageBlock>();
        private PageCaption caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockEmbedPost instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockEmbedPost) {
                instance = (PageBlockEmbedPost)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.webpageId(instance.webpageId());
                this.author(instance.author());
                this.addAllBlocks(instance.blocks());
                this.caption(instance.caption());
                this.url(instance.url());
                this.authorPhotoId(instance.authorPhotoId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder webpageId(long webpageId) {
            this.webpageId = webpageId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder authorPhotoId(long authorPhotoId) {
            this.authorPhotoId = authorPhotoId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addBlock(PageBlock element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(PageBlock ... elements) {
            for (PageBlock element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder blocks(Iterable<? extends PageBlock> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends PageBlock> elements) {
            for (PageBlock pageBlock : elements) {
                this.blocks.add(Objects.requireNonNull(pageBlock, "blocks element"));
            }
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePageBlockEmbedPost build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockEmbedPost(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("webpageId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("authorPhotoId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockEmbedPost, some of required attributes are not set " + attributes;
        }
    }
}

