/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockMap;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockMap
implements PageBlockMap {
    private final int identifier;
    private final GeoPoint geo;
    private final int zoom;
    private final int w;
    private final int h;
    private final PageCaption caption;

    private ImmutablePageBlockMap(GeoPoint geo, int zoom, int w, int h, PageCaption caption) {
        this.geo = Objects.requireNonNull(geo, "geo");
        this.zoom = zoom;
        this.w = w;
        this.h = h;
        this.caption = Objects.requireNonNull(caption, "caption");
        this.identifier = PageBlockMap.super.identifier();
    }

    private ImmutablePageBlockMap(Builder builder) {
        this.geo = builder.geo;
        this.zoom = builder.zoom;
        this.w = builder.w;
        this.h = builder.h;
        this.caption = builder.caption;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockMap.super.identifier();
    }

    private ImmutablePageBlockMap(int identifier, GeoPoint geo, int zoom, int w, int h, PageCaption caption) {
        this.identifier = identifier;
        this.geo = geo;
        this.zoom = zoom;
        this.w = w;
        this.h = h;
        this.caption = caption;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public GeoPoint geo() {
        return this.geo;
    }

    @Override
    public int zoom() {
        return this.zoom;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    public final ImmutablePageBlockMap withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockMap(value, this.geo, this.zoom, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockMap withGeo(GeoPoint value) {
        if (this.geo == value) {
            return this;
        }
        GeoPoint newValue = Objects.requireNonNull(value, "geo");
        return new ImmutablePageBlockMap(this.identifier, newValue, this.zoom, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockMap withZoom(int value) {
        if (this.zoom == value) {
            return this;
        }
        return new ImmutablePageBlockMap(this.identifier, this.geo, value, this.w, this.h, this.caption);
    }

    public final ImmutablePageBlockMap withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutablePageBlockMap(this.identifier, this.geo, this.zoom, value, this.h, this.caption);
    }

    public final ImmutablePageBlockMap withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutablePageBlockMap(this.identifier, this.geo, this.zoom, this.w, value, this.caption);
    }

    public final ImmutablePageBlockMap withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockMap(this.identifier, this.geo, this.zoom, this.w, this.h, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockMap && this.equalTo(0, (ImmutablePageBlockMap)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockMap another) {
        return this.identifier == another.identifier && this.geo.equals(another.geo) && this.zoom == another.zoom && this.w == another.w && this.h == another.h && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.geo.hashCode();
        h$$ += (h$$ << 5) + this.zoom;
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        h$$ += (h$$ << 5) + this.caption.hashCode();
        return h$$;
    }

    public String toString() {
        return "PageBlockMap{identifier=" + this.identifier + ", geo=" + this.geo + ", zoom=" + this.zoom + ", w=" + this.w + ", h=" + this.h + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockMap of(GeoPoint geo, int zoom, int w, int h, PageCaption caption) {
        return new ImmutablePageBlockMap(geo, zoom, w, h, caption);
    }

    public static ImmutablePageBlockMap copyOf(PageBlockMap instance) {
        if (instance instanceof ImmutablePageBlockMap) {
            return (ImmutablePageBlockMap)instance;
        }
        return ImmutablePageBlockMap.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GEO = 1L;
        private static final long INIT_BIT_ZOOM = 2L;
        private static final long INIT_BIT_W = 4L;
        private static final long INIT_BIT_H = 8L;
        private static final long INIT_BIT_CAPTION = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private GeoPoint geo;
        private int zoom;
        private int w;
        private int h;
        private PageCaption caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockMap instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockMap) {
                instance = (PageBlockMap)object;
                this.geo(instance.geo());
                this.h(instance.h());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.caption(instance.caption());
                this.zoom(instance.zoom());
                this.w(instance.w());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder geo(GeoPoint geo) {
            this.geo = Objects.requireNonNull(geo, "geo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder zoom(int zoom) {
            this.zoom = zoom;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutablePageBlockMap build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockMap(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("geo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("zoom");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("h");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockMap, some of required attributes are not set " + attributes;
        }
    }
}

