/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockOrderedList;
import telegram4j.tl.PageListOrderedItem;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockOrderedList
implements PageBlockOrderedList {
    private final int identifier;
    private final List<PageListOrderedItem> items;

    private ImmutablePageBlockOrderedList(Builder builder) {
        this.items = ImmutablePageBlockOrderedList.createUnmodifiableList(true, builder.items);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockOrderedList.super.identifier();
    }

    private ImmutablePageBlockOrderedList(int identifier, List<PageListOrderedItem> items) {
        this.identifier = identifier;
        this.items = items;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PageListOrderedItem> items() {
        return this.items;
    }

    public final ImmutablePageBlockOrderedList withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockOrderedList(value, this.items);
    }

    public final ImmutablePageBlockOrderedList withItems(PageListOrderedItem ... elements) {
        List<PageListOrderedItem> newValue = ImmutablePageBlockOrderedList.createUnmodifiableList(false, ImmutablePageBlockOrderedList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageBlockOrderedList(this.identifier, newValue);
    }

    public final ImmutablePageBlockOrderedList withItems(Iterable<? extends PageListOrderedItem> elements) {
        if (this.items == elements) {
            return this;
        }
        List<PageListOrderedItem> newValue = ImmutablePageBlockOrderedList.createUnmodifiableList(false, ImmutablePageBlockOrderedList.createSafeList(elements, true, false));
        return new ImmutablePageBlockOrderedList(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockOrderedList && this.equalTo(0, (ImmutablePageBlockOrderedList)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockOrderedList another) {
        return this.identifier == another.identifier && this.items.equals(another.items);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.items.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockOrderedList{identifier=" + this.identifier + ", items=" + this.items + "}";
    }

    public static ImmutablePageBlockOrderedList copyOf(PageBlockOrderedList instance) {
        if (instance instanceof ImmutablePageBlockOrderedList) {
            return (ImmutablePageBlockOrderedList)instance;
        }
        return ImmutablePageBlockOrderedList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<PageListOrderedItem> items = new ArrayList<PageListOrderedItem>();

        private Builder() {
        }

        public final Builder from(PageBlockOrderedList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlockOrderedList) {
                instance = (PageBlockOrderedList)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllItems(instance.items());
            }
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addItem(PageListOrderedItem element) {
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        public final Builder addItems(PageListOrderedItem ... elements) {
            for (PageListOrderedItem element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        public final Builder items(Iterable<? extends PageListOrderedItem> elements) {
            this.items.clear();
            return this.addAllItems(elements);
        }

        public final Builder addAllItems(Iterable<? extends PageListOrderedItem> elements) {
            for (PageListOrderedItem pageListOrderedItem : elements) {
                this.items.add(Objects.requireNonNull(pageListOrderedItem, "items element"));
            }
            return this;
        }

        public ImmutablePageBlockOrderedList build() {
            return new ImmutablePageBlockOrderedList(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

