/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockPhoto;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockPhoto
implements PageBlockPhoto {
    private final int identifier;
    private final int flags;
    private final long photoId;
    private final PageCaption caption;
    @Nullable
    private final String url;
    @Nullable
    private final Long webpageId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageBlockPhoto(long photoId, PageCaption caption) {
        this.photoId = photoId;
        this.caption = Objects.requireNonNull(caption, "caption");
        this.url = null;
        this.webpageId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePageBlockPhoto(Builder builder) {
        this.photoId = builder.photoId;
        this.caption = builder.caption;
        this.url = builder.url;
        this.webpageId = builder.webpageId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePageBlockPhoto(int identifier, int flags, long photoId, PageCaption caption, @Nullable String url, @Nullable Long webpageId) {
        this.identifier = identifier;
        this.flags = flags;
        this.photoId = photoId;
        this.caption = caption;
        this.url = url;
        this.webpageId = webpageId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageBlockPhoto.super.identifier();
    }

    private int flagsInitialize() {
        return PageBlockPhoto.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long photoId() {
        return this.photoId;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public Long webpageId() {
        return this.webpageId;
    }

    public final ImmutablePageBlockPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockPhoto(value, this.flags, this.photoId, this.caption, this.url, this.webpageId);
    }

    public final ImmutablePageBlockPhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePageBlockPhoto(this.identifier, value, this.photoId, this.caption, this.url, this.webpageId);
    }

    public final ImmutablePageBlockPhoto withPhotoId(long value) {
        if (this.photoId == value) {
            return this;
        }
        return new ImmutablePageBlockPhoto(this.identifier, this.flags, value, this.caption, this.url, this.webpageId);
    }

    public final ImmutablePageBlockPhoto withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockPhoto(this.identifier, this.flags, this.photoId, newValue, this.url, this.webpageId);
    }

    public final ImmutablePageBlockPhoto withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutablePageBlockPhoto(this.identifier, this.flags, this.photoId, this.caption, value, this.webpageId);
    }

    public final ImmutablePageBlockPhoto withWebpageId(@Nullable Long value) {
        if (Objects.equals(this.webpageId, value)) {
            return this;
        }
        return new ImmutablePageBlockPhoto(this.identifier, this.flags, this.photoId, this.caption, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockPhoto && this.equalTo(0, (ImmutablePageBlockPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockPhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.photoId == another.photoId && this.caption.equals(another.caption) && Objects.equals(this.url, another.url) && Objects.equals(this.webpageId, another.webpageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.photoId);
        h += (h << 5) + this.caption.hashCode();
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.webpageId);
        return h;
    }

    public String toString() {
        return "PageBlockPhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", photoId=" + this.photoId + ", caption=" + this.caption + ", url=" + this.url + ", webpageId=" + this.webpageId + "}";
    }

    public static ImmutablePageBlockPhoto of(long photoId, PageCaption caption) {
        return new ImmutablePageBlockPhoto(photoId, caption);
    }

    public static ImmutablePageBlockPhoto copyOf(PageBlockPhoto instance) {
        if (instance instanceof ImmutablePageBlockPhoto) {
            return (ImmutablePageBlockPhoto)instance;
        }
        return ImmutablePageBlockPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHOTO_ID = 1L;
        private static final long INIT_BIT_CAPTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private long photoId;
        private PageCaption caption;
        private String url;
        private Long webpageId;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockPhoto) {
                Long webpageIdValue;
                instance = (PageBlockPhoto)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((webpageIdValue = instance.webpageId()) != null) {
                    this.webpageId(webpageIdValue);
                }
                this.photoId(instance.photoId());
                this.caption(instance.caption());
                String urlValue = instance.url();
                if (urlValue != null) {
                    this.url(urlValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder photoId(long photoId) {
            this.photoId = photoId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder webpageId(@Nullable Long webpageId) {
            this.webpageId = webpageId;
            return this;
        }

        public ImmutablePageBlockPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("photoId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockPhoto, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageBlockPhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageBlockPhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PageBlockPhoto, attribute initializers form cycle " + attributes;
        }
    }
}

