/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockPreformatted;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockPreformatted
implements PageBlockPreformatted {
    private final int identifier;
    private final RichText text;
    private final String language;

    private ImmutablePageBlockPreformatted(RichText text, String language) {
        this.text = Objects.requireNonNull(text, "text");
        this.language = Objects.requireNonNull(language, "language");
        this.identifier = PageBlockPreformatted.super.identifier();
    }

    private ImmutablePageBlockPreformatted(Builder builder) {
        this.text = builder.text;
        this.language = builder.language;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockPreformatted.super.identifier();
    }

    private ImmutablePageBlockPreformatted(int identifier, RichText text, String language) {
        this.identifier = identifier;
        this.text = text;
        this.language = language;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public String language() {
        return this.language;
    }

    public final ImmutablePageBlockPreformatted withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockPreformatted(value, this.text, this.language);
    }

    public final ImmutablePageBlockPreformatted withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutablePageBlockPreformatted(this.identifier, newValue, this.language);
    }

    public final ImmutablePageBlockPreformatted withLanguage(String value) {
        String newValue = Objects.requireNonNull(value, "language");
        if (this.language.equals(newValue)) {
            return this;
        }
        return new ImmutablePageBlockPreformatted(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockPreformatted && this.equalTo(0, (ImmutablePageBlockPreformatted)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockPreformatted another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.language.equals(another.language);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.language.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockPreformatted{identifier=" + this.identifier + ", text=" + this.text + ", language=" + this.language + "}";
    }

    public static ImmutablePageBlockPreformatted of(RichText text, String language) {
        return new ImmutablePageBlockPreformatted(text, language);
    }

    public static ImmutablePageBlockPreformatted copyOf(PageBlockPreformatted instance) {
        if (instance instanceof ImmutablePageBlockPreformatted) {
            return (ImmutablePageBlockPreformatted)instance;
        }
        return ImmutablePageBlockPreformatted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_LANGUAGE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText text;
        private String language;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockPreformatted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockPreformatted) {
                instance = (PageBlockPreformatted)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.language(instance.language());
                this.text(instance.text());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder language(String language) {
            this.language = Objects.requireNonNull(language, "language");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageBlockPreformatted build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockPreformatted(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("language");
            }
            return "Cannot build PageBlockPreformatted, some of required attributes are not set " + attributes;
        }
    }
}

