/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockRelatedArticles;
import telegram4j.tl.PageRelatedArticle;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockRelatedArticles
implements PageBlockRelatedArticles {
    private final int identifier;
    private final RichText title;
    private final List<PageRelatedArticle> articles;

    private ImmutablePageBlockRelatedArticles(RichText title) {
        this.title = Objects.requireNonNull(title, "title");
        this.articles = Collections.emptyList();
        this.identifier = PageBlockRelatedArticles.super.identifier();
    }

    private ImmutablePageBlockRelatedArticles(Builder builder) {
        this.title = builder.title;
        this.articles = ImmutablePageBlockRelatedArticles.createUnmodifiableList(true, builder.articles);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageBlockRelatedArticles.super.identifier();
    }

    private ImmutablePageBlockRelatedArticles(int identifier, RichText title, List<PageRelatedArticle> articles) {
        this.identifier = identifier;
        this.title = title;
        this.articles = articles;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText title() {
        return this.title;
    }

    @Override
    public List<PageRelatedArticle> articles() {
        return this.articles;
    }

    public final ImmutablePageBlockRelatedArticles withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockRelatedArticles(value, this.title, this.articles);
    }

    public final ImmutablePageBlockRelatedArticles withTitle(RichText value) {
        if (this.title == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "title");
        return new ImmutablePageBlockRelatedArticles(this.identifier, newValue, this.articles);
    }

    public final ImmutablePageBlockRelatedArticles withArticles(PageRelatedArticle ... elements) {
        List<PageRelatedArticle> newValue = ImmutablePageBlockRelatedArticles.createUnmodifiableList(false, ImmutablePageBlockRelatedArticles.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageBlockRelatedArticles(this.identifier, this.title, newValue);
    }

    public final ImmutablePageBlockRelatedArticles withArticles(Iterable<? extends PageRelatedArticle> elements) {
        if (this.articles == elements) {
            return this;
        }
        List<PageRelatedArticle> newValue = ImmutablePageBlockRelatedArticles.createUnmodifiableList(false, ImmutablePageBlockRelatedArticles.createSafeList(elements, true, false));
        return new ImmutablePageBlockRelatedArticles(this.identifier, this.title, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockRelatedArticles && this.equalTo(0, (ImmutablePageBlockRelatedArticles)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockRelatedArticles another) {
        return this.identifier == another.identifier && this.title.equals(another.title) && this.articles.equals(another.articles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.articles.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockRelatedArticles{identifier=" + this.identifier + ", title=" + this.title + ", articles=" + this.articles + "}";
    }

    public static ImmutablePageBlockRelatedArticles of(RichText title) {
        return new ImmutablePageBlockRelatedArticles(title);
    }

    public static ImmutablePageBlockRelatedArticles copyOf(PageBlockRelatedArticles instance) {
        if (instance instanceof ImmutablePageBlockRelatedArticles) {
            return (ImmutablePageBlockRelatedArticles)instance;
        }
        return ImmutablePageBlockRelatedArticles.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private RichText title;
        private List<PageRelatedArticle> articles = new ArrayList<PageRelatedArticle>();

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockRelatedArticles instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockRelatedArticles) {
                instance = (PageBlockRelatedArticles)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllArticles(instance.articles());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder title(RichText title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addArticle(PageRelatedArticle element) {
            this.articles.add(Objects.requireNonNull(element, "articles element"));
            return this;
        }

        public final Builder addArticles(PageRelatedArticle ... elements) {
            for (PageRelatedArticle element : elements) {
                this.articles.add(Objects.requireNonNull(element, "articles element"));
            }
            return this;
        }

        public final Builder articles(Iterable<? extends PageRelatedArticle> elements) {
            this.articles.clear();
            return this.addAllArticles(elements);
        }

        public final Builder addAllArticles(Iterable<? extends PageRelatedArticle> elements) {
            for (PageRelatedArticle pageRelatedArticle : elements) {
                this.articles.add(Objects.requireNonNull(pageRelatedArticle, "articles element"));
            }
            return this;
        }

        public ImmutablePageBlockRelatedArticles build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockRelatedArticles(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build PageBlockRelatedArticles, some of required attributes are not set " + attributes;
        }
    }
}

