/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockTable;
import telegram4j.tl.PageTableRow;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockTable
implements PageBlockTable {
    private final int identifier;
    private final int flags;
    private final boolean bordered;
    private final boolean striped;
    private final RichText title;
    private final List<PageTableRow> rows;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageBlockTable(RichText title) {
        this.title = Objects.requireNonNull(title, "title");
        this.rows = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.bordered = this.initShim.bordered();
        this.striped = this.initShim.striped();
        this.initShim = null;
    }

    private ImmutablePageBlockTable(Builder builder) {
        this.title = builder.title;
        this.rows = ImmutablePageBlockTable.createUnmodifiableList(true, builder.rows);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.borderedIsSet()) {
            this.initShim.bordered(builder.bordered);
        }
        if (builder.stripedIsSet()) {
            this.initShim.striped(builder.striped);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.bordered = this.initShim.bordered();
        this.striped = this.initShim.striped();
        this.initShim = null;
    }

    private ImmutablePageBlockTable(int identifier, int flags, boolean bordered, boolean striped, RichText title, List<PageTableRow> rows) {
        this.identifier = identifier;
        this.flags = flags;
        this.bordered = bordered;
        this.striped = striped;
        this.title = title;
        this.rows = rows;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageBlockTable.super.identifier();
    }

    private int flagsInitialize() {
        return PageBlockTable.super.flags();
    }

    private boolean borderedInitialize() {
        return PageBlockTable.super.bordered();
    }

    private boolean stripedInitialize() {
        return PageBlockTable.super.striped();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean bordered() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bordered() : this.bordered;
    }

    @Override
    public boolean striped() {
        InitShim shim = this.initShim;
        return shim != null ? shim.striped() : this.striped;
    }

    @Override
    public RichText title() {
        return this.title;
    }

    @Override
    public List<PageTableRow> rows() {
        return this.rows;
    }

    public final ImmutablePageBlockTable withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockTable(value, this.flags, this.bordered, this.striped, this.title, this.rows);
    }

    public final ImmutablePageBlockTable withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePageBlockTable(this.identifier, value, this.bordered, this.striped, this.title, this.rows);
    }

    public final ImmutablePageBlockTable withBordered(boolean value) {
        if (this.bordered == value) {
            return this;
        }
        return new ImmutablePageBlockTable(this.identifier, this.flags, value, this.striped, this.title, this.rows);
    }

    public final ImmutablePageBlockTable withStriped(boolean value) {
        if (this.striped == value) {
            return this;
        }
        return new ImmutablePageBlockTable(this.identifier, this.flags, this.bordered, value, this.title, this.rows);
    }

    public final ImmutablePageBlockTable withTitle(RichText value) {
        if (this.title == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "title");
        return new ImmutablePageBlockTable(this.identifier, this.flags, this.bordered, this.striped, newValue, this.rows);
    }

    public final ImmutablePageBlockTable withRows(PageTableRow ... elements) {
        List<PageTableRow> newValue = ImmutablePageBlockTable.createUnmodifiableList(false, ImmutablePageBlockTable.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageBlockTable(this.identifier, this.flags, this.bordered, this.striped, this.title, newValue);
    }

    public final ImmutablePageBlockTable withRows(Iterable<? extends PageTableRow> elements) {
        if (this.rows == elements) {
            return this;
        }
        List<PageTableRow> newValue = ImmutablePageBlockTable.createUnmodifiableList(false, ImmutablePageBlockTable.createSafeList(elements, true, false));
        return new ImmutablePageBlockTable(this.identifier, this.flags, this.bordered, this.striped, this.title, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockTable && this.equalTo(0, (ImmutablePageBlockTable)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockTable another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.bordered == another.bordered && this.striped == another.striped && this.title.equals(another.title) && this.rows.equals(another.rows);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.bordered);
        h += (h << 5) + Boolean.hashCode(this.striped);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.rows.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockTable{identifier=" + this.identifier + ", flags=" + this.flags + ", bordered=" + this.bordered + ", striped=" + this.striped + ", title=" + this.title + ", rows=" + this.rows + "}";
    }

    public static ImmutablePageBlockTable of(RichText title) {
        return new ImmutablePageBlockTable(title);
    }

    public static ImmutablePageBlockTable copyOf(PageBlockTable instance) {
        if (instance instanceof ImmutablePageBlockTable) {
            return (ImmutablePageBlockTable)instance;
        }
        return ImmutablePageBlockTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BORDERED = 4L;
        private static final long OPT_BIT_STRIPED = 8L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean bordered;
        private boolean striped;
        private RichText title;
        private List<PageTableRow> rows = new ArrayList<PageTableRow>();

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockTable) {
                instance = (PageBlockTable)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.striped(instance.striped());
                this.bordered(instance.bordered());
                this.title(instance.title());
                this.addAllRows(instance.rows());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder bordered(boolean bordered) {
            this.bordered = bordered;
            this.optBits |= 4L;
            return this;
        }

        public final Builder striped(boolean striped) {
            this.striped = striped;
            this.optBits |= 8L;
            return this;
        }

        public final Builder title(RichText title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRow(PageTableRow element) {
            this.rows.add(Objects.requireNonNull(element, "rows element"));
            return this;
        }

        public final Builder addRows(PageTableRow ... elements) {
            for (PageTableRow element : elements) {
                this.rows.add(Objects.requireNonNull(element, "rows element"));
            }
            return this;
        }

        public final Builder rows(Iterable<? extends PageTableRow> elements) {
            this.rows.clear();
            return this.addAllRows(elements);
        }

        public final Builder addAllRows(Iterable<? extends PageTableRow> elements) {
            for (PageTableRow pageTableRow : elements) {
                this.rows.add(Objects.requireNonNull(pageTableRow, "rows element"));
            }
            return this;
        }

        public ImmutablePageBlockTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockTable(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean borderedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean stripedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build PageBlockTable, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte borderedBuildStage = 0;
        private boolean bordered;
        private byte stripedBuildStage = 0;
        private boolean striped;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageBlockTable.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageBlockTable.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean bordered() {
            if (this.borderedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.borderedBuildStage == 0) {
                this.borderedBuildStage = (byte)-1;
                this.bordered = ImmutablePageBlockTable.this.borderedInitialize();
                this.borderedBuildStage = 1;
            }
            return this.bordered;
        }

        void bordered(boolean bordered) {
            this.bordered = bordered;
            this.borderedBuildStage = 1;
        }

        boolean striped() {
            if (this.stripedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stripedBuildStage == 0) {
                this.stripedBuildStage = (byte)-1;
                this.striped = ImmutablePageBlockTable.this.stripedInitialize();
                this.stripedBuildStage = 1;
            }
            return this.striped;
        }

        void striped(boolean striped) {
            this.striped = striped;
            this.stripedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.borderedBuildStage == -1) {
                attributes.add("bordered");
            }
            if (this.stripedBuildStage == -1) {
                attributes.add("striped");
            }
            return "Cannot build PageBlockTable, attribute initializers form cycle " + attributes;
        }
    }
}

