/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageBlockVideo;
import telegram4j.tl.PageCaption;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageBlockVideo
implements PageBlockVideo {
    private final int identifier;
    private final int flags;
    private final boolean autoplay;
    private final boolean loop;
    private final long videoId;
    private final PageCaption caption;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageBlockVideo(long videoId, PageCaption caption) {
        this.videoId = videoId;
        this.caption = Objects.requireNonNull(caption, "caption");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.autoplay = this.initShim.autoplay();
        this.loop = this.initShim.loop();
        this.initShim = null;
    }

    private ImmutablePageBlockVideo(Builder builder) {
        this.videoId = builder.videoId;
        this.caption = builder.caption;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.autoplayIsSet()) {
            this.initShim.autoplay(builder.autoplay);
        }
        if (builder.loopIsSet()) {
            this.initShim.loop(builder.loop);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.autoplay = this.initShim.autoplay();
        this.loop = this.initShim.loop();
        this.initShim = null;
    }

    private ImmutablePageBlockVideo(int identifier, int flags, boolean autoplay, boolean loop, long videoId, PageCaption caption) {
        this.identifier = identifier;
        this.flags = flags;
        this.autoplay = autoplay;
        this.loop = loop;
        this.videoId = videoId;
        this.caption = caption;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageBlockVideo.super.identifier();
    }

    private int flagsInitialize() {
        return PageBlockVideo.super.flags();
    }

    private boolean autoplayInitialize() {
        return PageBlockVideo.super.autoplay();
    }

    private boolean loopInitialize() {
        return PageBlockVideo.super.loop();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean autoplay() {
        InitShim shim = this.initShim;
        return shim != null ? shim.autoplay() : this.autoplay;
    }

    @Override
    public boolean loop() {
        InitShim shim = this.initShim;
        return shim != null ? shim.loop() : this.loop;
    }

    @Override
    public long videoId() {
        return this.videoId;
    }

    @Override
    public PageCaption caption() {
        return this.caption;
    }

    public final ImmutablePageBlockVideo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageBlockVideo(value, this.flags, this.autoplay, this.loop, this.videoId, this.caption);
    }

    public final ImmutablePageBlockVideo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePageBlockVideo(this.identifier, value, this.autoplay, this.loop, this.videoId, this.caption);
    }

    public final ImmutablePageBlockVideo withAutoplay(boolean value) {
        if (this.autoplay == value) {
            return this;
        }
        return new ImmutablePageBlockVideo(this.identifier, this.flags, value, this.loop, this.videoId, this.caption);
    }

    public final ImmutablePageBlockVideo withLoop(boolean value) {
        if (this.loop == value) {
            return this;
        }
        return new ImmutablePageBlockVideo(this.identifier, this.flags, this.autoplay, value, this.videoId, this.caption);
    }

    public final ImmutablePageBlockVideo withVideoId(long value) {
        if (this.videoId == value) {
            return this;
        }
        return new ImmutablePageBlockVideo(this.identifier, this.flags, this.autoplay, this.loop, value, this.caption);
    }

    public final ImmutablePageBlockVideo withCaption(PageCaption value) {
        if (this.caption == value) {
            return this;
        }
        PageCaption newValue = Objects.requireNonNull(value, "caption");
        return new ImmutablePageBlockVideo(this.identifier, this.flags, this.autoplay, this.loop, this.videoId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageBlockVideo && this.equalTo(0, (ImmutablePageBlockVideo)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageBlockVideo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.autoplay == another.autoplay && this.loop == another.loop && this.videoId == another.videoId && this.caption.equals(another.caption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.autoplay);
        h += (h << 5) + Boolean.hashCode(this.loop);
        h += (h << 5) + Long.hashCode(this.videoId);
        h += (h << 5) + this.caption.hashCode();
        return h;
    }

    public String toString() {
        return "PageBlockVideo{identifier=" + this.identifier + ", flags=" + this.flags + ", autoplay=" + this.autoplay + ", loop=" + this.loop + ", videoId=" + this.videoId + ", caption=" + this.caption + "}";
    }

    public static ImmutablePageBlockVideo of(long videoId, PageCaption caption) {
        return new ImmutablePageBlockVideo(videoId, caption);
    }

    public static ImmutablePageBlockVideo copyOf(PageBlockVideo instance) {
        if (instance instanceof ImmutablePageBlockVideo) {
            return (ImmutablePageBlockVideo)instance;
        }
        return ImmutablePageBlockVideo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VIDEO_ID = 1L;
        private static final long INIT_BIT_CAPTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_AUTOPLAY = 4L;
        private static final long OPT_BIT_LOOP = 8L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean autoplay;
        private boolean loop;
        private long videoId;
        private PageCaption caption;

        private Builder() {
        }

        public final Builder from(PageBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageBlockVideo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageBlock instance;
            long bits = 0L;
            if (object instanceof PageBlock) {
                instance = (PageBlock)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageBlockVideo) {
                instance = (PageBlockVideo)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.caption(instance.caption());
                this.videoId(instance.videoId());
                this.loop(instance.loop());
                this.autoplay(instance.autoplay());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder autoplay(boolean autoplay) {
            this.autoplay = autoplay;
            this.optBits |= 4L;
            return this;
        }

        public final Builder loop(boolean loop) {
            this.loop = loop;
            this.optBits |= 8L;
            return this;
        }

        public final Builder videoId(long videoId) {
            this.videoId = videoId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder caption(PageCaption caption) {
            this.caption = Objects.requireNonNull(caption, "caption");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageBlockVideo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageBlockVideo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean autoplayIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean loopIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("videoId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("caption");
            }
            return "Cannot build PageBlockVideo, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte autoplayBuildStage = 0;
        private boolean autoplay;
        private byte loopBuildStage = 0;
        private boolean loop;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageBlockVideo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageBlockVideo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean autoplay() {
            if (this.autoplayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.autoplayBuildStage == 0) {
                this.autoplayBuildStage = (byte)-1;
                this.autoplay = ImmutablePageBlockVideo.this.autoplayInitialize();
                this.autoplayBuildStage = 1;
            }
            return this.autoplay;
        }

        void autoplay(boolean autoplay) {
            this.autoplay = autoplay;
            this.autoplayBuildStage = 1;
        }

        boolean loop() {
            if (this.loopBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.loopBuildStage == 0) {
                this.loopBuildStage = (byte)-1;
                this.loop = ImmutablePageBlockVideo.this.loopInitialize();
                this.loopBuildStage = 1;
            }
            return this.loop;
        }

        void loop(boolean loop) {
            this.loop = loop;
            this.loopBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.autoplayBuildStage == -1) {
                attributes.add("autoplay");
            }
            if (this.loopBuildStage == -1) {
                attributes.add("loop");
            }
            return "Cannot build PageBlockVideo, attribute initializers form cycle " + attributes;
        }
    }
}

