/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageCaption;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageCaption
implements PageCaption {
    private final int identifier;
    private final RichText text;
    private final RichText credit;

    private ImmutablePageCaption(RichText text, RichText credit) {
        this.text = Objects.requireNonNull(text, "text");
        this.credit = Objects.requireNonNull(credit, "credit");
        this.identifier = PageCaption.super.identifier();
    }

    private ImmutablePageCaption(Builder builder) {
        this.text = builder.text;
        this.credit = builder.credit;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageCaption.super.identifier();
    }

    private ImmutablePageCaption(int identifier, RichText text, RichText credit) {
        this.identifier = identifier;
        this.text = text;
        this.credit = credit;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public RichText credit() {
        return this.credit;
    }

    public final ImmutablePageCaption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageCaption(value, this.text, this.credit);
    }

    public final ImmutablePageCaption withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutablePageCaption(this.identifier, newValue, this.credit);
    }

    public final ImmutablePageCaption withCredit(RichText value) {
        if (this.credit == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "credit");
        return new ImmutablePageCaption(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageCaption && this.equalTo(0, (ImmutablePageCaption)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageCaption another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.credit.equals(another.credit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.credit.hashCode();
        return h;
    }

    public String toString() {
        return "PageCaption{identifier=" + this.identifier + ", text=" + this.text + ", credit=" + this.credit + "}";
    }

    public static ImmutablePageCaption of(RichText text, RichText credit) {
        return new ImmutablePageCaption(text, credit);
    }

    public static ImmutablePageCaption copyOf(PageCaption instance) {
        if (instance instanceof ImmutablePageCaption) {
            return (ImmutablePageCaption)instance;
        }
        return ImmutablePageCaption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_CREDIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText text;
        private RichText credit;

        private Builder() {
        }

        public final Builder from(PageCaption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageCaption instance;
            long bits = 0L;
            if (object instanceof PageCaption) {
                instance = (PageCaption)object;
                this.credit(instance.credit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder credit(RichText credit) {
            this.credit = Objects.requireNonNull(credit, "credit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageCaption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageCaption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("credit");
            }
            return "Cannot build PageCaption, some of required attributes are not set " + attributes;
        }
    }
}

