/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageListItem;
import telegram4j.tl.PageListItemBlocks;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageListItemBlocks
implements PageListItemBlocks {
    private final int identifier;
    private final List<PageBlock> blocks;

    private ImmutablePageListItemBlocks(Builder builder) {
        this.blocks = ImmutablePageListItemBlocks.createUnmodifiableList(true, builder.blocks);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageListItemBlocks.super.identifier();
    }

    private ImmutablePageListItemBlocks(int identifier, List<PageBlock> blocks) {
        this.identifier = identifier;
        this.blocks = blocks;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PageBlock> blocks() {
        return this.blocks;
    }

    public final ImmutablePageListItemBlocks withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageListItemBlocks(value, this.blocks);
    }

    public final ImmutablePageListItemBlocks withBlocks(PageBlock ... elements) {
        List<PageBlock> newValue = ImmutablePageListItemBlocks.createUnmodifiableList(false, ImmutablePageListItemBlocks.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageListItemBlocks(this.identifier, newValue);
    }

    public final ImmutablePageListItemBlocks withBlocks(Iterable<? extends PageBlock> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<PageBlock> newValue = ImmutablePageListItemBlocks.createUnmodifiableList(false, ImmutablePageListItemBlocks.createSafeList(elements, true, false));
        return new ImmutablePageListItemBlocks(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageListItemBlocks && this.equalTo(0, (ImmutablePageListItemBlocks)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageListItemBlocks another) {
        return this.identifier == another.identifier && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        return "PageListItemBlocks{identifier=" + this.identifier + ", blocks=" + this.blocks + "}";
    }

    public static ImmutablePageListItemBlocks copyOf(PageListItemBlocks instance) {
        if (instance instanceof ImmutablePageListItemBlocks) {
            return (ImmutablePageListItemBlocks)instance;
        }
        return ImmutablePageListItemBlocks.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<PageBlock> blocks = new ArrayList<PageBlock>();

        private Builder() {
        }

        public final Builder from(PageListItemBlocks instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageListItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageListItem instance;
            long bits = 0L;
            if (object instanceof PageListItemBlocks) {
                instance = (PageListItemBlocks)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllBlocks(instance.blocks());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageListItem) {
                instance = (PageListItem)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addBlock(PageBlock element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(PageBlock ... elements) {
            for (PageBlock element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder blocks(Iterable<? extends PageBlock> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends PageBlock> elements) {
            for (PageBlock pageBlock : elements) {
                this.blocks.add(Objects.requireNonNull(pageBlock, "blocks element"));
            }
            return this;
        }

        public ImmutablePageListItemBlocks build() {
            return new ImmutablePageListItemBlocks(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

