/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageListItem;
import telegram4j.tl.PageListItemText;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageListItemText
implements PageListItemText {
    private final int identifier;
    private final RichText text;

    private ImmutablePageListItemText(RichText text) {
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = PageListItemText.super.identifier();
    }

    private ImmutablePageListItemText(Builder builder) {
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageListItemText.super.identifier();
    }

    private ImmutablePageListItemText(int identifier, RichText text) {
        this.identifier = identifier;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    public final ImmutablePageListItemText withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageListItemText(value, this.text);
    }

    public final ImmutablePageListItemText withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutablePageListItemText(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageListItemText && this.equalTo(0, (ImmutablePageListItemText)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageListItemText another) {
        return this.identifier == another.identifier && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "PageListItemText{identifier=" + this.identifier + ", text=" + this.text + "}";
    }

    public static ImmutablePageListItemText of(RichText text) {
        return new ImmutablePageListItemText(text);
    }

    public static ImmutablePageListItemText copyOf(PageListItemText instance) {
        if (instance instanceof ImmutablePageListItemText) {
            return (ImmutablePageListItemText)instance;
        }
        return ImmutablePageListItemText.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private RichText text;

        private Builder() {
        }

        public final Builder from(PageListItemText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageListItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageListItem instance;
            long bits = 0L;
            if (object instanceof PageListItemText) {
                instance = (PageListItemText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageListItem) {
                instance = (PageListItem)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePageListItemText build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageListItemText(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build PageListItemText, some of required attributes are not set " + attributes;
        }
    }
}

