/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageBlock;
import telegram4j.tl.PageListOrderedItem;
import telegram4j.tl.PageListOrderedItemBlocks;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageListOrderedItemBlocks
implements PageListOrderedItemBlocks {
    private final int identifier;
    private final String num;
    private final List<PageBlock> blocks;

    private ImmutablePageListOrderedItemBlocks(String num) {
        this.num = Objects.requireNonNull(num, "num");
        this.blocks = Collections.emptyList();
        this.identifier = PageListOrderedItemBlocks.super.identifier();
    }

    private ImmutablePageListOrderedItemBlocks(Builder builder) {
        this.num = builder.num;
        this.blocks = ImmutablePageListOrderedItemBlocks.createUnmodifiableList(true, builder.blocks);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageListOrderedItemBlocks.super.identifier();
    }

    private ImmutablePageListOrderedItemBlocks(int identifier, String num, List<PageBlock> blocks) {
        this.identifier = identifier;
        this.num = num;
        this.blocks = blocks;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String num() {
        return this.num;
    }

    @Override
    public List<PageBlock> blocks() {
        return this.blocks;
    }

    public final ImmutablePageListOrderedItemBlocks withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageListOrderedItemBlocks(value, this.num, this.blocks);
    }

    public final ImmutablePageListOrderedItemBlocks withNum(String value) {
        String newValue = Objects.requireNonNull(value, "num");
        if (this.num.equals(newValue)) {
            return this;
        }
        return new ImmutablePageListOrderedItemBlocks(this.identifier, newValue, this.blocks);
    }

    public final ImmutablePageListOrderedItemBlocks withBlocks(PageBlock ... elements) {
        List<PageBlock> newValue = ImmutablePageListOrderedItemBlocks.createUnmodifiableList(false, ImmutablePageListOrderedItemBlocks.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageListOrderedItemBlocks(this.identifier, this.num, newValue);
    }

    public final ImmutablePageListOrderedItemBlocks withBlocks(Iterable<? extends PageBlock> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<PageBlock> newValue = ImmutablePageListOrderedItemBlocks.createUnmodifiableList(false, ImmutablePageListOrderedItemBlocks.createSafeList(elements, true, false));
        return new ImmutablePageListOrderedItemBlocks(this.identifier, this.num, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageListOrderedItemBlocks && this.equalTo(0, (ImmutablePageListOrderedItemBlocks)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageListOrderedItemBlocks another) {
        return this.identifier == another.identifier && this.num.equals(another.num) && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.num.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        return "PageListOrderedItemBlocks{identifier=" + this.identifier + ", num=" + this.num + ", blocks=" + this.blocks + "}";
    }

    public static ImmutablePageListOrderedItemBlocks of(String num) {
        return new ImmutablePageListOrderedItemBlocks(num);
    }

    public static ImmutablePageListOrderedItemBlocks copyOf(PageListOrderedItemBlocks instance) {
        if (instance instanceof ImmutablePageListOrderedItemBlocks) {
            return (ImmutablePageListOrderedItemBlocks)instance;
        }
        return ImmutablePageListOrderedItemBlocks.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NUM = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String num;
        private List<PageBlock> blocks = new ArrayList<PageBlock>();

        private Builder() {
        }

        public final Builder from(PageListOrderedItemBlocks instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageListOrderedItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageListOrderedItem instance;
            long bits = 0L;
            if (object instanceof PageListOrderedItemBlocks) {
                instance = (PageListOrderedItemBlocks)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllBlocks(instance.blocks());
                if ((bits & 2L) == 0L) {
                    this.num(instance.num());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageListOrderedItem) {
                instance = (PageListOrderedItem)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.num(instance.num());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder num(String num) {
            this.num = Objects.requireNonNull(num, "num");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addBlock(PageBlock element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(PageBlock ... elements) {
            for (PageBlock element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder blocks(Iterable<? extends PageBlock> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends PageBlock> elements) {
            for (PageBlock pageBlock : elements) {
                this.blocks.add(Objects.requireNonNull(pageBlock, "blocks element"));
            }
            return this;
        }

        public ImmutablePageListOrderedItemBlocks build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageListOrderedItemBlocks(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("num");
            }
            return "Cannot build PageListOrderedItemBlocks, some of required attributes are not set " + attributes;
        }
    }
}

