/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PageListOrderedItem;
import telegram4j.tl.PageListOrderedItemText;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageListOrderedItemText
implements PageListOrderedItemText {
    private final int identifier;
    private final String num;
    private final RichText text;

    private ImmutablePageListOrderedItemText(String num, RichText text) {
        this.num = Objects.requireNonNull(num, "num");
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = PageListOrderedItemText.super.identifier();
    }

    private ImmutablePageListOrderedItemText(Builder builder) {
        this.num = builder.num;
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageListOrderedItemText.super.identifier();
    }

    private ImmutablePageListOrderedItemText(int identifier, String num, RichText text) {
        this.identifier = identifier;
        this.num = num;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String num() {
        return this.num;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    public final ImmutablePageListOrderedItemText withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageListOrderedItemText(value, this.num, this.text);
    }

    public final ImmutablePageListOrderedItemText withNum(String value) {
        String newValue = Objects.requireNonNull(value, "num");
        if (this.num.equals(newValue)) {
            return this;
        }
        return new ImmutablePageListOrderedItemText(this.identifier, newValue, this.text);
    }

    public final ImmutablePageListOrderedItemText withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutablePageListOrderedItemText(this.identifier, this.num, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageListOrderedItemText && this.equalTo(0, (ImmutablePageListOrderedItemText)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageListOrderedItemText another) {
        return this.identifier == another.identifier && this.num.equals(another.num) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.num.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "PageListOrderedItemText{identifier=" + this.identifier + ", num=" + this.num + ", text=" + this.text + "}";
    }

    public static ImmutablePageListOrderedItemText of(String num, RichText text) {
        return new ImmutablePageListOrderedItemText(num, text);
    }

    public static ImmutablePageListOrderedItemText copyOf(PageListOrderedItemText instance) {
        if (instance instanceof ImmutablePageListOrderedItemText) {
            return (ImmutablePageListOrderedItemText)instance;
        }
        return ImmutablePageListOrderedItemText.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NUM = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String num;
        private RichText text;

        private Builder() {
        }

        public final Builder from(PageListOrderedItemText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageListOrderedItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageListOrderedItem instance;
            long bits = 0L;
            if (object instanceof PageListOrderedItemText) {
                instance = (PageListOrderedItemText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.num(instance.num());
                    bits |= 2L;
                }
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageListOrderedItem) {
                instance = (PageListOrderedItem)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.num(instance.num());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder num(String num) {
            this.num = Objects.requireNonNull(num, "num");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePageListOrderedItemText build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageListOrderedItemText(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("num");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build PageListOrderedItemText, some of required attributes are not set " + attributes;
        }
    }
}

