/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PageRelatedArticle;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageRelatedArticle
implements PageRelatedArticle {
    private final int identifier;
    private final int flags;
    private final String url;
    private final long webpageId;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final Long photoId;
    @Nullable
    private final String author;
    @Nullable
    private final Integer publishedDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageRelatedArticle(String url, long webpageId) {
        this.url = Objects.requireNonNull(url, "url");
        this.webpageId = webpageId;
        this.title = null;
        this.description = null;
        this.photoId = null;
        this.author = null;
        this.publishedDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePageRelatedArticle(Builder builder) {
        this.url = builder.url;
        this.webpageId = builder.webpageId;
        this.title = builder.title;
        this.description = builder.description;
        this.photoId = builder.photoId;
        this.author = builder.author;
        this.publishedDate = builder.publishedDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePageRelatedArticle(int identifier, int flags, String url, long webpageId, @Nullable String title, @Nullable String description, @Nullable Long photoId, @Nullable String author, @Nullable Integer publishedDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.url = url;
        this.webpageId = webpageId;
        this.title = title;
        this.description = description;
        this.photoId = photoId;
        this.author = author;
        this.publishedDate = publishedDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageRelatedArticle.super.identifier();
    }

    private int flagsInitialize() {
        return PageRelatedArticle.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public long webpageId() {
        return this.webpageId;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public Long photoId() {
        return this.photoId;
    }

    @Override
    @Nullable
    public String author() {
        return this.author;
    }

    @Override
    @Nullable
    public Integer publishedDate() {
        return this.publishedDate;
    }

    public final ImmutablePageRelatedArticle withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageRelatedArticle(value, this.flags, this.url, this.webpageId, this.title, this.description, this.photoId, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, value, this.url, this.webpageId, this.title, this.description, this.photoId, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, newValue, this.webpageId, this.title, this.description, this.photoId, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withWebpageId(long value) {
        if (this.webpageId == value) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, this.url, value, this.title, this.description, this.photoId, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, this.url, this.webpageId, value, this.description, this.photoId, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, this.url, this.webpageId, this.title, value, this.photoId, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withPhotoId(@Nullable Long value) {
        if (Objects.equals(this.photoId, value)) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, this.url, this.webpageId, this.title, this.description, value, this.author, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withAuthor(@Nullable String value) {
        if (Objects.equals(this.author, value)) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, this.url, this.webpageId, this.title, this.description, this.photoId, value, this.publishedDate);
    }

    public final ImmutablePageRelatedArticle withPublishedDate(@Nullable Integer value) {
        if (Objects.equals(this.publishedDate, value)) {
            return this;
        }
        return new ImmutablePageRelatedArticle(this.identifier, this.flags, this.url, this.webpageId, this.title, this.description, this.photoId, this.author, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageRelatedArticle && this.equalTo(0, (ImmutablePageRelatedArticle)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageRelatedArticle another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.url.equals(another.url) && this.webpageId == another.webpageId && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.photoId, another.photoId) && Objects.equals(this.author, another.author) && Objects.equals(this.publishedDate, another.publishedDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Long.hashCode(this.webpageId);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.photoId);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.publishedDate);
        return h;
    }

    public String toString() {
        return "PageRelatedArticle{identifier=" + this.identifier + ", flags=" + this.flags + ", url=" + this.url + ", webpageId=" + this.webpageId + ", title=" + this.title + ", description=" + this.description + ", photoId=" + this.photoId + ", author=" + this.author + ", publishedDate=" + this.publishedDate + "}";
    }

    public static ImmutablePageRelatedArticle of(String url, long webpageId) {
        return new ImmutablePageRelatedArticle(url, webpageId);
    }

    public static ImmutablePageRelatedArticle copyOf(PageRelatedArticle instance) {
        if (instance instanceof ImmutablePageRelatedArticle) {
            return (ImmutablePageRelatedArticle)instance;
        }
        return ImmutablePageRelatedArticle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_WEBPAGE_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private String url;
        private long webpageId;
        private String title;
        private String description;
        private Long photoId;
        private String author;
        private Integer publishedDate;

        private Builder() {
        }

        public final Builder from(PageRelatedArticle instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageRelatedArticle instance;
            long bits = 0L;
            if (object instanceof PageRelatedArticle) {
                String titleValue;
                Integer publishedDateValue;
                Long photoIdValue;
                instance = (PageRelatedArticle)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.webpageId(instance.webpageId());
                String authorValue = instance.author();
                if (authorValue != null) {
                    this.author(authorValue);
                }
                this.flags(instance.flags());
                String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((photoIdValue = instance.photoId()) != null) {
                    this.photoId(photoIdValue);
                }
                if ((publishedDateValue = instance.publishedDate()) != null) {
                    this.publishedDate(publishedDateValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                this.url(instance.url());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder webpageId(long webpageId) {
            this.webpageId = webpageId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder photoId(@Nullable Long photoId) {
            this.photoId = photoId;
            return this;
        }

        public final Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        public final Builder publishedDate(@Nullable Integer publishedDate) {
            this.publishedDate = publishedDate;
            return this;
        }

        public ImmutablePageRelatedArticle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageRelatedArticle(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("webpageId");
            }
            return "Cannot build PageRelatedArticle, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageRelatedArticle.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageRelatedArticle.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PageRelatedArticle, attribute initializers form cycle " + attributes;
        }
    }
}

