/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PageTableCell;
import telegram4j.tl.RichText;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageTableCell
implements PageTableCell {
    private final int identifier;
    private final int flags;
    private final boolean header;
    private final boolean alignCenter;
    private final boolean alignRight;
    private final boolean valignMiddle;
    private final boolean valignBottom;
    @Nullable
    private final RichText text;
    @Nullable
    private final Integer colspan;
    @Nullable
    private final Integer rowspan;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePageTableCell INSTANCE = ImmutablePageTableCell.validate(new ImmutablePageTableCell());

    private ImmutablePageTableCell() {
        this.text = null;
        this.colspan = null;
        this.rowspan = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.header = this.initShim.header();
        this.alignCenter = this.initShim.alignCenter();
        this.alignRight = this.initShim.alignRight();
        this.valignMiddle = this.initShim.valignMiddle();
        this.valignBottom = this.initShim.valignBottom();
        this.initShim = null;
    }

    private ImmutablePageTableCell(Builder builder) {
        this.text = builder.text;
        this.colspan = builder.colspan;
        this.rowspan = builder.rowspan;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.headerIsSet()) {
            this.initShim.header(builder.header);
        }
        if (builder.alignCenterIsSet()) {
            this.initShim.alignCenter(builder.alignCenter);
        }
        if (builder.alignRightIsSet()) {
            this.initShim.alignRight(builder.alignRight);
        }
        if (builder.valignMiddleIsSet()) {
            this.initShim.valignMiddle(builder.valignMiddle);
        }
        if (builder.valignBottomIsSet()) {
            this.initShim.valignBottom(builder.valignBottom);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.header = this.initShim.header();
        this.alignCenter = this.initShim.alignCenter();
        this.alignRight = this.initShim.alignRight();
        this.valignMiddle = this.initShim.valignMiddle();
        this.valignBottom = this.initShim.valignBottom();
        this.initShim = null;
    }

    private ImmutablePageTableCell(int identifier, int flags, boolean header, boolean alignCenter, boolean alignRight, boolean valignMiddle, boolean valignBottom, @Nullable RichText text, @Nullable Integer colspan, @Nullable Integer rowspan) {
        this.identifier = identifier;
        this.flags = flags;
        this.header = header;
        this.alignCenter = alignCenter;
        this.alignRight = alignRight;
        this.valignMiddle = valignMiddle;
        this.valignBottom = valignBottom;
        this.text = text;
        this.colspan = colspan;
        this.rowspan = rowspan;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PageTableCell.super.identifier();
    }

    private int flagsInitialize() {
        return PageTableCell.super.flags();
    }

    private boolean headerInitialize() {
        return PageTableCell.super.header();
    }

    private boolean alignCenterInitialize() {
        return PageTableCell.super.alignCenter();
    }

    private boolean alignRightInitialize() {
        return PageTableCell.super.alignRight();
    }

    private boolean valignMiddleInitialize() {
        return PageTableCell.super.valignMiddle();
    }

    private boolean valignBottomInitialize() {
        return PageTableCell.super.valignBottom();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean header() {
        InitShim shim = this.initShim;
        return shim != null ? shim.header() : this.header;
    }

    @Override
    public boolean alignCenter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alignCenter() : this.alignCenter;
    }

    @Override
    public boolean alignRight() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alignRight() : this.alignRight;
    }

    @Override
    public boolean valignMiddle() {
        InitShim shim = this.initShim;
        return shim != null ? shim.valignMiddle() : this.valignMiddle;
    }

    @Override
    public boolean valignBottom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.valignBottom() : this.valignBottom;
    }

    @Override
    @Nullable
    public RichText text() {
        return this.text;
    }

    @Override
    @Nullable
    public Integer colspan() {
        return this.colspan;
    }

    @Override
    @Nullable
    public Integer rowspan() {
        return this.rowspan;
    }

    public final ImmutablePageTableCell withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(value, this.flags, this.header, this.alignCenter, this.alignRight, this.valignMiddle, this.valignBottom, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, value, this.header, this.alignCenter, this.alignRight, this.valignMiddle, this.valignBottom, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withHeader(boolean value) {
        if (this.header == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, value, this.alignCenter, this.alignRight, this.valignMiddle, this.valignBottom, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withAlignCenter(boolean value) {
        if (this.alignCenter == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, value, this.alignRight, this.valignMiddle, this.valignBottom, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withAlignRight(boolean value) {
        if (this.alignRight == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, this.alignCenter, value, this.valignMiddle, this.valignBottom, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withValignMiddle(boolean value) {
        if (this.valignMiddle == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, this.alignCenter, this.alignRight, value, this.valignBottom, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withValignBottom(boolean value) {
        if (this.valignBottom == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, this.alignCenter, this.alignRight, this.valignMiddle, value, this.text, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withText(@Nullable RichText value) {
        if (this.text == value) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, this.alignCenter, this.alignRight, this.valignMiddle, this.valignBottom, value, this.colspan, this.rowspan));
    }

    public final ImmutablePageTableCell withColspan(@Nullable Integer value) {
        if (Objects.equals(this.colspan, value)) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, this.alignCenter, this.alignRight, this.valignMiddle, this.valignBottom, this.text, value, this.rowspan));
    }

    public final ImmutablePageTableCell withRowspan(@Nullable Integer value) {
        if (Objects.equals(this.rowspan, value)) {
            return this;
        }
        return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this.identifier, this.flags, this.header, this.alignCenter, this.alignRight, this.valignMiddle, this.valignBottom, this.text, this.colspan, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageTableCell && this.equalTo(0, (ImmutablePageTableCell)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageTableCell another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.header == another.header && this.alignCenter == another.alignCenter && this.alignRight == another.alignRight && this.valignMiddle == another.valignMiddle && this.valignBottom == another.valignBottom && Objects.equals(this.text, another.text) && Objects.equals(this.colspan, another.colspan) && Objects.equals(this.rowspan, another.rowspan);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.header);
        h += (h << 5) + Boolean.hashCode(this.alignCenter);
        h += (h << 5) + Boolean.hashCode(this.alignRight);
        h += (h << 5) + Boolean.hashCode(this.valignMiddle);
        h += (h << 5) + Boolean.hashCode(this.valignBottom);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.colspan);
        h += (h << 5) + Objects.hashCode(this.rowspan);
        return h;
    }

    public String toString() {
        return "PageTableCell{identifier=" + this.identifier + ", flags=" + this.flags + ", header=" + this.header + ", alignCenter=" + this.alignCenter + ", alignRight=" + this.alignRight + ", valignMiddle=" + this.valignMiddle + ", valignBottom=" + this.valignBottom + ", text=" + this.text + ", colspan=" + this.colspan + ", rowspan=" + this.rowspan + "}";
    }

    public static ImmutablePageTableCell of() {
        return INSTANCE;
    }

    private static ImmutablePageTableCell validate(ImmutablePageTableCell instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePageTableCell copyOf(PageTableCell instance) {
        if (instance instanceof ImmutablePageTableCell) {
            return (ImmutablePageTableCell)instance;
        }
        return ImmutablePageTableCell.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HEADER = 4L;
        private static final long OPT_BIT_ALIGN_CENTER = 8L;
        private static final long OPT_BIT_ALIGN_RIGHT = 16L;
        private static final long OPT_BIT_VALIGN_MIDDLE = 32L;
        private static final long OPT_BIT_VALIGN_BOTTOM = 64L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean header;
        private boolean alignCenter;
        private boolean alignRight;
        private boolean valignMiddle;
        private boolean valignBottom;
        private RichText text;
        private Integer colspan;
        private Integer rowspan;

        private Builder() {
        }

        public final Builder from(PageTableCell instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageTableCell instance;
            long bits = 0L;
            if (object instanceof PageTableCell) {
                Integer rowspanValue;
                instance = (PageTableCell)object;
                Integer colspanValue = instance.colspan();
                if (colspanValue != null) {
                    this.colspan(colspanValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((rowspanValue = instance.rowspan()) != null) {
                    this.rowspan(rowspanValue);
                }
                this.flags(instance.flags());
                this.header(instance.header());
                this.alignCenter(instance.alignCenter());
                this.valignBottom(instance.valignBottom());
                RichText textValue = instance.text();
                if (textValue != null) {
                    this.text(textValue);
                }
                this.valignMiddle(instance.valignMiddle());
                this.alignRight(instance.alignRight());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder header(boolean header) {
            this.header = header;
            this.optBits |= 4L;
            return this;
        }

        public final Builder alignCenter(boolean alignCenter) {
            this.alignCenter = alignCenter;
            this.optBits |= 8L;
            return this;
        }

        public final Builder alignRight(boolean alignRight) {
            this.alignRight = alignRight;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder valignMiddle(boolean valignMiddle) {
            this.valignMiddle = valignMiddle;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder valignBottom(boolean valignBottom) {
            this.valignBottom = valignBottom;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder text(@Nullable RichText text) {
            this.text = text;
            return this;
        }

        public final Builder colspan(@Nullable Integer colspan) {
            this.colspan = colspan;
            return this;
        }

        public final Builder rowspan(@Nullable Integer rowspan) {
            this.rowspan = rowspan;
            return this;
        }

        public ImmutablePageTableCell build() {
            return ImmutablePageTableCell.validate(new ImmutablePageTableCell(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean headerIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean alignCenterIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean alignRightIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean valignMiddleIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean valignBottomIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte headerBuildStage = 0;
        private boolean header;
        private byte alignCenterBuildStage = 0;
        private boolean alignCenter;
        private byte alignRightBuildStage = 0;
        private boolean alignRight;
        private byte valignMiddleBuildStage = 0;
        private boolean valignMiddle;
        private byte valignBottomBuildStage = 0;
        private boolean valignBottom;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePageTableCell.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePageTableCell.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean header() {
            if (this.headerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.headerBuildStage == 0) {
                this.headerBuildStage = (byte)-1;
                this.header = ImmutablePageTableCell.this.headerInitialize();
                this.headerBuildStage = 1;
            }
            return this.header;
        }

        void header(boolean header) {
            this.header = header;
            this.headerBuildStage = 1;
        }

        boolean alignCenter() {
            if (this.alignCenterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alignCenterBuildStage == 0) {
                this.alignCenterBuildStage = (byte)-1;
                this.alignCenter = ImmutablePageTableCell.this.alignCenterInitialize();
                this.alignCenterBuildStage = 1;
            }
            return this.alignCenter;
        }

        void alignCenter(boolean alignCenter) {
            this.alignCenter = alignCenter;
            this.alignCenterBuildStage = 1;
        }

        boolean alignRight() {
            if (this.alignRightBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alignRightBuildStage == 0) {
                this.alignRightBuildStage = (byte)-1;
                this.alignRight = ImmutablePageTableCell.this.alignRightInitialize();
                this.alignRightBuildStage = 1;
            }
            return this.alignRight;
        }

        void alignRight(boolean alignRight) {
            this.alignRight = alignRight;
            this.alignRightBuildStage = 1;
        }

        boolean valignMiddle() {
            if (this.valignMiddleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valignMiddleBuildStage == 0) {
                this.valignMiddleBuildStage = (byte)-1;
                this.valignMiddle = ImmutablePageTableCell.this.valignMiddleInitialize();
                this.valignMiddleBuildStage = 1;
            }
            return this.valignMiddle;
        }

        void valignMiddle(boolean valignMiddle) {
            this.valignMiddle = valignMiddle;
            this.valignMiddleBuildStage = 1;
        }

        boolean valignBottom() {
            if (this.valignBottomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valignBottomBuildStage == 0) {
                this.valignBottomBuildStage = (byte)-1;
                this.valignBottom = ImmutablePageTableCell.this.valignBottomInitialize();
                this.valignBottomBuildStage = 1;
            }
            return this.valignBottom;
        }

        void valignBottom(boolean valignBottom) {
            this.valignBottom = valignBottom;
            this.valignBottomBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.headerBuildStage == -1) {
                attributes.add("header");
            }
            if (this.alignCenterBuildStage == -1) {
                attributes.add("alignCenter");
            }
            if (this.alignRightBuildStage == -1) {
                attributes.add("alignRight");
            }
            if (this.valignMiddleBuildStage == -1) {
                attributes.add("valignMiddle");
            }
            if (this.valignBottomBuildStage == -1) {
                attributes.add("valignBottom");
            }
            return "Cannot build PageTableCell, attribute initializers form cycle " + attributes;
        }
    }
}

