/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PageTableCell;
import telegram4j.tl.PageTableRow;
import telegram4j.tl.api.TlObject;

public final class ImmutablePageTableRow
implements PageTableRow {
    private final int identifier;
    private final List<PageTableCell> cells;

    private ImmutablePageTableRow(Builder builder) {
        this.cells = ImmutablePageTableRow.createUnmodifiableList(true, builder.cells);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PageTableRow.super.identifier();
    }

    private ImmutablePageTableRow(int identifier, List<PageTableCell> cells) {
        this.identifier = identifier;
        this.cells = cells;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PageTableCell> cells() {
        return this.cells;
    }

    public final ImmutablePageTableRow withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePageTableRow(value, this.cells);
    }

    public final ImmutablePageTableRow withCells(PageTableCell ... elements) {
        List<PageTableCell> newValue = ImmutablePageTableRow.createUnmodifiableList(false, ImmutablePageTableRow.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePageTableRow(this.identifier, newValue);
    }

    public final ImmutablePageTableRow withCells(Iterable<? extends PageTableCell> elements) {
        if (this.cells == elements) {
            return this;
        }
        List<PageTableCell> newValue = ImmutablePageTableRow.createUnmodifiableList(false, ImmutablePageTableRow.createSafeList(elements, true, false));
        return new ImmutablePageTableRow(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageTableRow && this.equalTo(0, (ImmutablePageTableRow)another);
    }

    private boolean equalTo(int synthetic, ImmutablePageTableRow another) {
        return this.identifier == another.identifier && this.cells.equals(another.cells);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.cells.hashCode();
        return h;
    }

    public String toString() {
        return "PageTableRow{identifier=" + this.identifier + ", cells=" + this.cells + "}";
    }

    public static ImmutablePageTableRow copyOf(PageTableRow instance) {
        if (instance instanceof ImmutablePageTableRow) {
            return (ImmutablePageTableRow)instance;
        }
        return ImmutablePageTableRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<PageTableCell> cells = new ArrayList<PageTableCell>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageTableRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PageTableRow) {
                instance = (PageTableRow)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllCells(instance.cells());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addCell(PageTableCell element) {
            this.cells.add(Objects.requireNonNull(element, "cells element"));
            return this;
        }

        public final Builder addCells(PageTableCell ... elements) {
            for (PageTableCell element : elements) {
                this.cells.add(Objects.requireNonNull(element, "cells element"));
            }
            return this;
        }

        public final Builder cells(Iterable<? extends PageTableCell> elements) {
            this.cells.clear();
            return this.addAllCells(elements);
        }

        public final Builder addAllCells(Iterable<? extends PageTableCell> elements) {
            for (PageTableCell pageTableCell : elements) {
                this.cells.add(Objects.requireNonNull(pageTableCell, "cells element"));
            }
            return this;
        }

        public ImmutablePageTableRow build() {
            return new ImmutablePageTableRow(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

