/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PasswordKdfAlgo;
import telegram4j.tl.PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow
implements PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow {
    private final int identifier;
    private final ByteBuf salt1;
    private final ByteBuf salt2;
    private final int g;
    private final ByteBuf p;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(int g) {
        this.g = g;
        this.salt1 = null;
        this.salt2 = null;
        this.p = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(Builder builder) {
        this.salt1 = builder.salt1_build();
        this.salt2 = builder.salt2_build();
        this.g = builder.g;
        this.p = builder.p_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(int identifier, ByteBuf salt1, ByteBuf salt2, int g, ByteBuf p) {
        this.identifier = identifier;
        this.salt1 = salt1;
        this.salt2 = salt2;
        this.g = g;
        this.p = p;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf salt1() {
        return this.salt1.duplicate();
    }

    @Override
    public ByteBuf salt2() {
        return this.salt2.duplicate();
    }

    @Override
    public int g() {
        return this.g;
    }

    @Override
    public ByteBuf p() {
        return this.p.duplicate();
    }

    public final ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(value, this.salt1, this.salt2, this.g, this.p);
    }

    public ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow withSalt1(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.salt1 == newValue) {
            return this;
        }
        return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(this.identifier, newValue, this.salt2, this.g, this.p);
    }

    public ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow withSalt2(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.salt2 == newValue) {
            return this;
        }
        return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(this.identifier, this.salt1, newValue, this.g, this.p);
    }

    public final ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow withG(int value) {
        if (this.g == value) {
            return this;
        }
        return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(this.identifier, this.salt1, this.salt2, value, this.p);
    }

    public ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow withP(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.p == newValue) {
            return this;
        }
        return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(this.identifier, this.salt1, this.salt2, this.g, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow && this.equalTo(0, (ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow another) {
        return this.identifier == another.identifier && this.salt1().equals((Object)another.salt1()) && this.salt2().equals((Object)another.salt2()) && this.g == another.g && this.p().equals((Object)another.p());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.salt1().hashCode();
        h += (h << 5) + this.salt2().hashCode();
        h += (h << 5) + this.g;
        h += (h << 5) + this.p().hashCode();
        return h;
    }

    public String toString() {
        return "PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow{identifier=" + this.identifier + ", salt1=" + ByteBufUtil.hexDump((ByteBuf)this.salt1) + ", salt2=" + ByteBufUtil.hexDump((ByteBuf)this.salt2) + ", g=" + this.g + ", p=" + ByteBufUtil.hexDump((ByteBuf)this.p) + "}";
    }

    public static ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow of(int g) {
        return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(g);
    }

    public static ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow copyOf(PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow instance) {
        if (instance instanceof ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow) {
            return (ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow)instance;
        }
        return ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_G = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf salt1_value = null;
        private ByteBuf salt2_value = null;
        private ByteBuf p_value = null;
        private int identifier;
        private int g;

        private Builder() {
        }

        public final Builder from(PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PasswordKdfAlgo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PasswordKdfAlgo instance;
            long bits = 0L;
            if (object instanceof PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow) {
                instance = (PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow)object;
                this.p(instance.p());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.salt1(instance.salt1());
                this.salt2(instance.salt2());
                this.g(instance.g());
            }
            if (object instanceof PasswordKdfAlgo) {
                instance = (PasswordKdfAlgo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder salt1(ByteBuf value) {
            this.salt1_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder salt2(ByteBuf value) {
            this.salt2_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder g(int g) {
            this.g = g;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder p(ByteBuf value) {
            this.p_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("g");
            }
            return "Cannot build PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow, some of required attributes are not set " + attributes;
        }

        private ByteBuf salt1_build() {
            return Objects.requireNonNull(this.salt1_value);
        }

        private ByteBuf salt2_build() {
            return Objects.requireNonNull(this.salt2_value);
        }

        private ByteBuf p_build() {
            return Objects.requireNonNull(this.p_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow, attribute initializers form cycle " + attributes;
        }
    }
}

