/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.PasswordKdfAlgo;
import telegram4j.tl.PasswordKdfAlgoUnknown;
import telegram4j.tl.api.TlObject;

public final class ImmutablePasswordKdfAlgoUnknown
implements PasswordKdfAlgoUnknown {
    private final int identifier;
    private static final ImmutablePasswordKdfAlgoUnknown INSTANCE = ImmutablePasswordKdfAlgoUnknown.validate(new ImmutablePasswordKdfAlgoUnknown());

    private ImmutablePasswordKdfAlgoUnknown() {
        this.identifier = PasswordKdfAlgoUnknown.super.identifier();
    }

    private ImmutablePasswordKdfAlgoUnknown(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : PasswordKdfAlgoUnknown.super.identifier();
    }

    private ImmutablePasswordKdfAlgoUnknown(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutablePasswordKdfAlgoUnknown withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePasswordKdfAlgoUnknown.validate(new ImmutablePasswordKdfAlgoUnknown(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordKdfAlgoUnknown && this.equalTo(0, (ImmutablePasswordKdfAlgoUnknown)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordKdfAlgoUnknown another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "PasswordKdfAlgoUnknown{identifier=" + this.identifier + "}";
    }

    public static ImmutablePasswordKdfAlgoUnknown of() {
        return INSTANCE;
    }

    private static ImmutablePasswordKdfAlgoUnknown validate(ImmutablePasswordKdfAlgoUnknown instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePasswordKdfAlgoUnknown copyOf(PasswordKdfAlgoUnknown instance) {
        if (instance instanceof ImmutablePasswordKdfAlgoUnknown) {
            return (ImmutablePasswordKdfAlgoUnknown)instance;
        }
        return ImmutablePasswordKdfAlgoUnknown.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(PasswordKdfAlgo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PasswordKdfAlgoUnknown instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PasswordKdfAlgo instance;
            long bits = 0L;
            if (object instanceof PasswordKdfAlgo) {
                instance = (PasswordKdfAlgo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PasswordKdfAlgoUnknown) {
                instance = (PasswordKdfAlgoUnknown)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePasswordKdfAlgoUnknown build() {
            return ImmutablePasswordKdfAlgoUnknown.validate(new ImmutablePasswordKdfAlgoUnknown(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

