/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PaymentCharge;
import telegram4j.tl.api.TlObject;

public final class ImmutablePaymentCharge
implements PaymentCharge {
    private final int identifier;
    private final String id;
    private final String providerChargeId;

    private ImmutablePaymentCharge(String id, String providerChargeId) {
        this.id = Objects.requireNonNull(id, "id");
        this.providerChargeId = Objects.requireNonNull(providerChargeId, "providerChargeId");
        this.identifier = PaymentCharge.super.identifier();
    }

    private ImmutablePaymentCharge(Builder builder) {
        this.id = builder.id;
        this.providerChargeId = builder.providerChargeId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : PaymentCharge.super.identifier();
    }

    private ImmutablePaymentCharge(int identifier, String id, String providerChargeId) {
        this.identifier = identifier;
        this.id = id;
        this.providerChargeId = providerChargeId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String providerChargeId() {
        return this.providerChargeId;
    }

    public final ImmutablePaymentCharge withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePaymentCharge(value, this.id, this.providerChargeId);
    }

    public final ImmutablePaymentCharge withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentCharge(this.identifier, newValue, this.providerChargeId);
    }

    public final ImmutablePaymentCharge withProviderChargeId(String value) {
        String newValue = Objects.requireNonNull(value, "providerChargeId");
        if (this.providerChargeId.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentCharge(this.identifier, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentCharge && this.equalTo(0, (ImmutablePaymentCharge)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaymentCharge another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.providerChargeId.equals(another.providerChargeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.providerChargeId.hashCode();
        return h;
    }

    public String toString() {
        return "PaymentCharge{identifier=" + this.identifier + ", id=" + this.id + ", providerChargeId=" + this.providerChargeId + "}";
    }

    public static ImmutablePaymentCharge of(String id, String providerChargeId) {
        return new ImmutablePaymentCharge(id, providerChargeId);
    }

    public static ImmutablePaymentCharge copyOf(PaymentCharge instance) {
        if (instance instanceof ImmutablePaymentCharge) {
            return (ImmutablePaymentCharge)instance;
        }
        return ImmutablePaymentCharge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROVIDER_CHARGE_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String id;
        private String providerChargeId;

        private Builder() {
        }

        public final Builder from(PaymentCharge instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaymentCharge instance;
            long bits = 0L;
            if (object instanceof PaymentCharge) {
                instance = (PaymentCharge)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.providerChargeId(instance.providerChargeId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder providerChargeId(String providerChargeId) {
            this.providerChargeId = Objects.requireNonNull(providerChargeId, "providerChargeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePaymentCharge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaymentCharge(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("providerChargeId");
            }
            return "Cannot build PaymentCharge, some of required attributes are not set " + attributes;
        }
    }
}

